<?php $__env->startPush("head"); ?>

    <link rel="stylesheet" href="<?php echo e(asset('css/custom_css_defined.css')); ?>">

    <!-- Datatable -->
    <link href="<?php echo e(asset('template_assets')); ?>/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('template_assets')); ?>/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('template_assets')); ?>/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

<?php $__env->stopPush(); ?>


<?php $__env->startSection('title',$pageTitle); ?>

<?php $__env->startSection('body'); ?>

    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"> All Inspections </h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="example3" class="table table-bordered table-striped verticle-middle table-responsive-sm">
                        <thead>


                        <tr>
                            <td scope="col">#</td>
                            <th >Package</th>
                            <th >Customer</th>
                            <th >Car</th>
                            <th >Start at</th>
                            <th >End At</th>
                            <th >Action</th>
                        </tr>


                        </thead>
                        <tbody>

                        <?php ($counter = 1); ?>

                        <?php $__currentLoopData = $quick_checks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr class="alert alert-dismissible">

                                <td><?php echo e($counter); ?></td>
                                <td><?php echo e($list->package_name); ?></td>
                                <td>
                                    <?php echo e($list->customer_name); ?> /  <?php echo e($list->customer_country_code); ?>-<?php echo e($list->customer_contact); ?>

                                </td>
                                <td>

                                    <span class="badge badge-warning"> <?php echo e($list->car_make); ?></span>
                                    <span class="badge badge-warning"> <?php echo e($list->car_plate_number); ?></span>

                                </td>

                                <td>
                                    <?php echo e($list->start_at); ?>

                                    <br>
                                    <?php echo e(\Carbon\Carbon::parse($list->start_at)->diffForhumans()); ?>


                                </td>

                                <td>
                                    <?php if(!empty($list->end_at)): ?>

                                    <?php echo e($list->end_at); ?>

                                    <br>
                                    Took <?php echo e(\Carbon\Carbon::parse($list->end_at)->diffInMinutes(\Carbon\Carbon::parse($list->start_at))); ?> Minutes

                                    <?php else: ?>
                                        <label class="badge badge-info">  In Progress </label>

                                    <?php endif; ?>

                                </td>

                                <td>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-log')): ?>
                                    <a title="Inspection Logs"  class="mr-4"  target="_blank" href="<?php echo e(route('panel.quick-check.inspection.logs',$list->qc_id)); ?>" >
                                        <i class="fa fa-sticky-note-o ak-action-anchor"></i>
                                    </a>
                                    <?php endif; ?>


                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-sms-sent')): ?>
                                    <a  title="Send SMS" class="mr-4" onclick="SendSms('<?php echo e($list->qc_id); ?>')" >
                                        <i class="fa fa-mail-forward ak-action-anchor"></i>
                                    </a>
                                    <?php endif; ?>



                                   <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-report')): ?>
                                       <?php if($list->customer_name !== null && $list->car_make !== null ): ?>
                                    <a title="Show Inspection Report" target="_blank" class="mr-4" href="<?php echo e(route('report.get-by-id',$list->qc_id)); ?>"  >
                                        <i class="fa fa-flag color-danger ak-action-anchor"></i>
                                    </a>
                                       <?php endif; ?>
                                   <?php endif; ?>



                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-continue')): ?>
                                    <?php if(\Carbon\Carbon::parse($list->start_at)->diffInHours(now()) < 4): ?>
                                        <a title="Continue Inspection" href="<?php echo e(route('panel.quick-check.inprogress',$list->qc_id)); ?>" class="mr-4">
                                            <i class="fa fa-play-circle color-muted ak-action-anchor "></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php endif; ?>


                                   <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-remove')): ?>
                                    <a title="Remove Inspection Data" class="mr-4" href="javascript:void(0);" onclick="DeleteInspectionModel('<?php echo e($list->qc_id); ?>','<?php echo e($counter++); ?>')" >
                                        <i class="fa fa-close color-danger ak-action-anchor"></i>
                                    </a>
                                   <?php endif; ?>




                                </td>
                            </tr>


                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-remove')): ?>

    <?php echo $__env->make('panel.quick_check.model.delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php endif; ?>


<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>

    <!-- Datatable -->
    <script src="<?php echo e(asset('template_assets')); ?>/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('template_assets')); ?>/js/plugins-init/datatables.init.js"></script>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-remove')): ?>
    <script>

        function DeleteInspectionModel(qc_id,id)
        {
               DeleteInspectionSetup(qc_id,id)
               document.getElementById('inspection-delete-button').click();

        }

    </script>
    <?php endif; ?>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>

        function ShowLoading()
        {
            Swal.fire('Processing your request, please wait...')
            Swal.showLoading()
        }

    </script>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-sms-sent')): ?>
    <script>

var SITEURL = "<?php echo e(url('/')); ?>";

        function SendSms(id){


            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: 'SMS has been sent successfully',
                showConfirmButton: false,
                timer: 1500
            })

            $.ajax({

                url:   SITEURL +  "/panel/sms-sender/"+id,
                type: "GET",
                success: function(data, textStatus, jqXHR){


                }

            });
        }

    </script>
    <?php endif; ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mohatigz/public_html/sites/check-first-main/resources/views/panel/quick_check/manage.blade.php ENDPATH**/ ?>