<?php $__env->startPush("head"); ?>

    <link rel="stylesheet" href="<?php echo e(asset('css/custom_css_defined.css')); ?>">

    <!-- Datatable -->
    <link href="<?php echo e(asset('template_assets')); ?>/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('template_assets')); ?>/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('template_assets')); ?>/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

    <style>

        .card{
            margin: 20px !important;
        }

    </style>

<?php $__env->stopPush(); ?>


<?php $__env->startSection('title','Dashboard'); ?>

<?php $__env->startSection('body'); ?>


    <div class="col-lg-12 row">


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customers-widget')): ?>
        <div class="card col-lg-3">
            <div class="card-body">
                <div class="d-flex align-items-end">
                    <div>
                        <p class="fs-14 mb-1">Customers</p>
                        <i class="fa fa-users fa-2x"></i>
                        <span class="fs-35 text-black font-w600"><?php echo e($widget['customers']); ?></span>

                    </div>
                    <canvas class="lineChart" id="chart_widget_2" height="85"></canvas>
                </div>
            </div>
        </div>
        <?php endif; ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cars-widget')): ?>
        <div class="card col-lg-3">
            <div class="card-body">
                <div class="d-flex align-items-end">
                    <div>
                        <p class="fs-14 mb-1">Cars</p>
                        <i class="fa fa-car fa-2x"></i>
                        <span class="fs-35 text-black font-w600"><?php echo e($widget['cars']); ?>	</span>

                    </div>
                    <canvas class="lineChart" id="chart_widget_2" height="85"></canvas>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-widget')): ?>
        <div class="card col-lg-3">
            <div class="card-body">
                <div class="d-flex align-items-end">
                    <div>
                        <p class="fs-14 mb-1">Inspection</p>
                        <i class="fa fa-flag fa-2x"></i>
                        <span class="fs-35 text-black font-w600"><?php echo e($widget['inspections']); ?>	</span>

                    </div>
                    <canvas class="lineChart" id="chart_widget_2" height="85"></canvas>
                </div>
            </div>
        </div>
        <?php endif; ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-in-process-widget')): ?>
        <div class="card col-lg-3">
            <div class="card-body">
                <div class="d-flex align-items-end">
                    <div>
                        <p class="fs-14 mb-1" style="white-space: nowrap">Inspection In Process</p>
                        <i class="fa fa-flag-checkered fa-2x"></i>
                        <span class="fs-35 text-black font-w600"><?php echo e($widget['pending_inspections']); ?>	</span>

                    </div>
                    <canvas class="lineChart" id="chart_widget_2" height="85"></canvas>
                </div>
            </div>
        </div>
        <?php endif; ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users-widget')): ?>
        <div class="card col-lg-3">
            <div class="card-body">
                <div class="d-flex align-items-end">
                    <div>
                        <p class="fs-14 mb-1" style="white-space: nowrap">User</p>
                        <i class="fa fa-user fa-2x"></i>
                        <span class="fs-35 text-black font-w600"><?php echo e($widget['users']); ?>	</span>

                    </div>
                    <canvas class="lineChart" id="chart_widget_2" height="85"></canvas>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('heads-widget')): ?>
        <div class="card col-lg-3">
            <div class="card-body">
                <div class="d-flex align-items-end">
                    <div>
                        <p class="fs-14 mb-1" style="white-space: nowrap">Heads</p>
                        <i class="fa fa-newspaper-o fa-2x"></i>
                        <span class="fs-35 text-black font-w600"><?php echo e($widget['heads']); ?>	</span>

                    </div>
                    <canvas class="lineChart" id="chart_widget_2" height="85"></canvas>
                </div>
            </div>
        </div>
        <?php endif; ?>


       <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('checks-widget')): ?>
        <div class="card col-lg-3">
            <div class="card-body">
                <div class="d-flex align-items-end">
                    <div>
                        <p class="fs-14 mb-1" style="white-space: nowrap">Checks</p>
                        <i class="fa fa-check-square-o fa-2x"></i>
                        <span class="fs-35 text-black font-w600"><?php echo e($widget['checks']); ?>	</span>

                    </div>
                    <canvas class="lineChart" id="chart_widget_2" height="85"></canvas>
                </div>
            </div>
        </div>
       <?php endif; ?>

       <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('packages-widget')): ?>
        <div class="card col-lg-3">
            <div class="card-body">
                <div class="d-flex align-items-end">
                    <div>
                        <p class="fs-14 mb-1" style="white-space: nowrap">Packages</p>
                        <i class="fa fa-cube fa-2x"></i>
                        <span class="fs-35 text-black font-w600"><?php echo e($widget['packages']); ?>	</span>

                    </div>
                    <canvas class="lineChart" id="chart_widget_2" height="85"></canvas>
                </div>
            </div>
        </div>
       <?php endif; ?>


       <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sms-sent-widget')): ?>
        <div class="card col-lg-3">
            <div class="card-body">
                <div class="d-flex align-items-end">
                    <div>
                        <p class="fs-14 mb-1" style="white-space: nowrap">SMS Sent</p>
                        <i class="fa fa-mail-forward ak-action-anchor"></i>
                        <span class="fs-35 text-black font-w600"><?php echo e($widget['sms_sent']); ?>	</span>

                    </div>
                    <canvas class="lineChart" id="chart_widget_2" height="85"></canvas>
                </div>
            </div>
        </div>
        <?php endif; ?>




    </div>


    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-in-process-dashboard')): ?>
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Inspections In Process </h4>
            </div>


            <div class="card-body">
                <div class="table-responsive">
                    <table id="example3" class="table table-bordered table-striped verticle-middle table-responsive-sm">
                        <thead>


                        <tr>
                            <th scope="col">Package</th>
                            <th scope="col">Customer</th>
                            <th scope="col">Car</th>
                            <th scope="col">Start at</th>
                            <th scope="col">Action</th>
                        </tr>


                        </thead>
                        <tbody>


                        <?php $__currentLoopData = $quick_checks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr class="alert alert-dismissible">

                            <td><?php echo e($list->package_name); ?></td>
                            <td>
                                <?php echo e($list->customer_name); ?>

                            </td>
                            <td>

                                <span class="badge badge-warning"> <?php echo e($list->car_make); ?></span>
                                <span class="badge badge-warning"> <?php echo e($list->car_plate_number); ?></span>

                            </td>

                            <td>
                                <?php echo e($list->start_at); ?>

                                <br>
                                <?php echo e(\Carbon\Carbon::parse($list->start_at)->diffForhumans()); ?>


                            </td>

                            <td>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection-continue')): ?>


                                    <a title="Start Inspection" href="<?php echo e(route('panel.quick-check.inprogress',$list->qc_id)); ?>" class="mr-4" data-toggle="tooltip"
                                         data-placement="top" title="Edit"><i
                                            class="fa fa-play-circle color-muted ak-action-anchor "></i>
                                    </a>

                                <?php endif; ?>


                            </td>
                        </tr>


                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>

    <!-- Datatable -->
    <script src="<?php echo e(asset('template_assets')); ?>/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('template_assets')); ?>/js/plugins-init/datatables.init.js"></script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mohatigz/public_html/sites/check-first-main/resources/views/panel/dashboard.blade.php ENDPATH**/ ?>