<button type="button" id="create_car_model_button" class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target=".create-car-model">Create</button>

<div class="modal fade create-car-model" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Cars</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('panel.car.created')); ?>" method="POST" enctype="multipart/form-data" id="create_cars_form">

                <?php echo csrf_field(); ?>

                <div class="modal-body">


                    <div class="form-row">

                        <div hidden class="form-group col-md-6">
                            <label>Car Name</label>
                            <input type="text" placeholder="Car Name" class="form-control" name="car_name" >
                        </div>

                        <div class="form-group col-md-6">
                            <label>Car Mileage</label>
                            <input type="text" placeholder="Car Mileage" class="form-control" name="car_mileage" >
                        </div>

                        <div class="form-group col-md-6">
                            <label>Image</label>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">Upload</span>
                                </div>
                                <div class="custom-file" style="overflow: hidden">
                                    <input type="file" class="custom-file-input" name="car_image">
                                    <label class="custom-file-label">Choose file</label>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="form-row">

                        <div class="form-group col-md-6" id="create-plate_number_div">
                            <label>Car Number Plate <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Car Number Plate" class="form-control" onchange="CreateCarNumberPlateValidator()" name="car_plate_number" id="create_car_number_plate"  required>
                        </div>

                        <div class="form-group col-md-6" id="email_div">
                            <label for="create_car_make" >Car Make  <span class="text-danger">*</span> </label>
                            <input id="create_car_make" onchange="CarMakeChange(this.id,'create_car_model_list')" list="create_car_make_list" type="text" placeholder="Car Make" class="form-control" name="car_make"  required >

                            <datalist id="create_car_make_list">

                                <?php $__currentLoopData = GetCarMakes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <option value="<?php echo e($list); ?>">

                               <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </datalist>


                        </div>

                        <div class="form-group col-md-6" id="email_div">
                            <label>Car Model </label>
                            <input type="text" onchange="CarModelChange(this.id,'create_car_year_list','create_car_make')" placeholder="Car Model" class="form-control" name="car_model" id="create_car_model" list="create_car_model_list" >

                            <datalist id="create_car_model_list">



                            </datalist>


                        </div>

                        <div class="form-group col-md-6" id="email_div">

                            <label>Car Year </label>

                            <input type="text" placeholder="Car Year" class="form-control" name="car_year" id="create_car_year" list="create_car_year_list" >


                            <datalist id="create_car_year_list">

                            </datalist>



                        </div>

                        <div class="form-group col-md-6" id="email_div">
                            <label>Car VIN Number</label>
                            <input type="text" placeholder="Car VIN Number" class="form-control" name="car_vin_number" id="create_car_vin_number" >
                        </div>

                        <div class="form-group col-md-6">
                            <label>Select Body Type</label>
                            <select class="form-control default-select" name="car_body_type" >

                                <option value>Choose Body Type</option>

                                <?php $__currentLoopData = GetBodyType(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($list->cby_id); ?>"><?php echo e($list->cby_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>

                        </div>

                    </div>


                </div>
                <?php if(Route::currentRouteName() === "panel.quick-check.index" || Route::currentRouteName() === "panel.quick-check.inprogress" ): ?>
                    <input type="hidden" name="access_type" value="api">
                <?php endif; ?>

                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                    <button type="submit" hidden id="create_car_form_submit"  class="btn btn-primary">Save changes</button>
                    <button type="button" onclick="SubmitCarForm()"  class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>



<?php $__env->startPush('scripts'); ?>


    <script>

        var SITEURL = "<?php echo e(url('/')); ?>";


        <?php if(Route::currentRouteName() === "panel.quick-check.index" || Route::currentRouteName() === "panel.quick-check.inprogress" ): ?>

        function  CarModelChange(id,list_id,make_id)
        {

            $('#'+list_id).empty();

            var car_make = document.getElementById(make_id).value;
            var car_model = document.getElementById(id).value;

            $.ajax({

                url: SITEURL + '/helper/get-car-year/'+car_make+'/'+car_model,
                type: 'GET',
                success: function(data) {

                    Object.entries(data).forEach(entry => {
                        const [key, value] = entry;
                        $('#'+list_id).append("<option value='" + value.year + "'>")
                        // console.log(key,value);
                    });


                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(jqXHR, textStatus, errorThrown);
                }


            });


        }

        function CarMakeChange(id,list_id)
        {
            $('#'+list_id).empty();

            var car_make = document.getElementById(id).value;


            $.ajax({

                url: SITEURL + '/helper/get-car-model/'+car_make,
                type: 'GET',
                success: function(data) {

                    Object.entries(data).forEach(entry => {
                        const [key, value] = entry;
                        $('#'+list_id).append("<option value='" + value.model + "'>")
                    });

                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(jqXHR, textStatus, errorThrown);
                }

            });

        }

        <?php endif; ?>


        function  CreateCarNumberPlateValidator()
        {
            $('#create-plate-number-span').remove();

            var plate_number =  document.getElementById('create_car_number_plate').value;

            $.ajax({
                url:   SITEURL + "/panel/cars/get-by-plate-number/"+plate_number+"/null",
                method: 'GET',
                success: function(data) {

                    if(typeof data === "object")
                    {
                        $('#create-plate_number_div').append('<span id="create-plate-number-span" class=" text-danger  fadeInUp">plate number already exists</span>');
                    }

                }



            });

        }

        function SubmitCarForm()
        {


            <?php if(Route::currentRouteName() === "panel.quick-check.index" || Route::currentRouteName() === "panel.quick-check.inprogress" ): ?>

            let custom_form = document.getElementById("create_cars_form");

            var formData = new FormData(custom_form);

            $.ajax({

                url: "<?php echo e(route('panel.car.created')); ?>",
                type: "POST",
                contentType: false,
                processData: false,
                data: formData,
                success: function(data, textStatus, jqXHR){

                    console.log(data);
                    if(typeof data.car_name !== "undefined")
                    {
                        var newOption = new Option(data.car_name+" - "+data.car_plate_number, data.car_id, true, true);
                        $('#car-select').append(newOption).trigger('change').select2();

                        <?php if( Route::currentRouteName() === "panel.quick-check.inprogress"): ?>

                        SentUpdatedInspection('car-select',' car updated ');

                        <?php endif; ?>
                        $('.create-car-model').modal('toggle');


                    }


                },
                error: function(jqXHR, textStatus, errorThrown){

                }
            })


            <?php else: ?>

            document.getElementById('create_car_form_submit').click();

            <?php endif; ?>

        }



    </script>

<?php $__env->stopPush(); ?>
<?php /**PATH /home/mohatigz/public_html/sites/check-first-main/resources/views/panel/cars/model/create.blade.php ENDPATH**/ ?>