<?php $__env->startPush("head"); ?>

    <link rel="stylesheet" href="<?php echo e(asset('css/custom_css_defined.css')); ?>">

    <!-- Datatable -->
    <link href="<?php echo e(asset('template_assets')); ?>/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('template_assets')); ?>/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('template_assets')); ?>/vendor/select2/css/select2.min.css">
    <link href="<?php echo e(asset('template_assets')); ?>/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

    <?php $__env->startSection('title', $pageTitle); ?>

<style>

    .card{
        margin: 20px;

    }

    @media  screen and (max-width: 700px) {
        .timeline-panel{
            flex-direction: column !important;
        }
        .ite-cards{
            padding: 10px 0px !important;
        }
        .ite-col{
            margin: 0px !important;
        }
        .card {
            margin: 10px 0px !important;
        }
        .ite-col-2{
            margin: 0px !important;
        }
        .custom-control{
            width: 100% !important;
            padding-left: 0px !important;

        }
    }

    #bordered_collapseFour-div{
        height: 800px;
    }

</style>

<?php $__env->stopPush(); ?>



<?php $__env->startSection('body'); ?>


    <div class="col-lg-12">

        <div class="card">
            <div class="card-header d-block">
                <h4 class="card-title">Quick Check Start</h4>
                <p class="m-0 subtitle">Please Follow the flow of work  <code> Package Selection </code> > <code> Customer Selection </code>   >  <code>Car and Body Type Selection </code>
                    > <code> Start Inspection </code> > <code> Finish </code>
                </p>

                <?php if(GetInspectionStatusById($id)->end_at !== null): ?>
                    <button id="inspection_end_button" onclick="ContinueInspection()" class="btn btn-primary" style="float: right"> Continue </button>

                <?php else: ?>
                    <button id="inspection_end_button" onclick="EndInspection()" class="btn btn-primary" style="float: right"> END </button>
                <?php endif; ?>

            </div>

            <div class="card-body">

                <div id="accordion-two" class="accordion accordion-danger-solid">


                    <form method="GET" id="quick_check_form">

                        <?php echo csrf_field(); ?>

                        

                        <div class="col-lg-6 row" style="margin-bottom: 2%">

                            <div class="col-lg-6">


                                <select  id="package-select" name="package" class="package_selection" onchange="GetHeadChecks()" >

                                    <option  value  >  Select Package </option>
                                    <?php $__empty_1 = true; $__currentLoopData = GetPackages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                                        <option  value="<?php echo e($list['package_id']); ?>" >  <?php echo e($list['package_name']); ?> </option>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                    <?php endif; ?>

                                </select>

                            </div>

                            <div class="col-lg-6">

                                <input type="number"  class="form-control" placeholder="Custom Price" id="custom_price" onchange="UpdateAdditionalNote(this.id)">

                            </div>

                        </div>

                        
                        <div  class="accordion__item">
                            <div class="accordion__header collapsed" data-toggle="collapse" data-target="#bordered_collapseTwo"> <span class="accordion__header--text"> <i class=" fa fa-user "> </i>  Customer </span>
                                <span class="accordion__header--indicator"></span>
                            </div>
                            <div id="bordered_collapseTwo" class="collapse accordion__body" data-parent="#accordion-two">
                                <div class="accordion__body--text">

                                    <div class="row">

                                        <div class="col-lg-6 ak-vertical-line">

                                            <select onchange="SentUpdatedInspection(this.id,' customer updated ')" id="customer-select" name="customer" class="package_selection">

                                                <option  value  >  Select Customer </option>
                                                <?php $__empty_1 = true; $__currentLoopData = GetCustomers(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                                                    <option  value="<?php echo e($list['customer_id']); ?>" >  <?php echo e($list['customer_name']); ?> / +<?php echo e($list['customer_country_code']); ?><?php echo e($list['customer_contact']); ?> </option>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                                <?php endif; ?>

                                            </select>

                                        </div>

                                        <div class="col-lg-6">

                                            <button class="btn btn-primary" type="button" onclick="document.getElementById('create_customer_model_button').click()"  style="float: right; margin-top: 10px"> Create New </button>

                                        </div>


                                    </div>



                                </div>
                            </div>
                        </div>

                        
                        <div  class="accordion__item">
                            <div class="accordion__header collapsed" data-toggle="collapse" data-target="#bordered_collapseThree"> <span class="accordion__header--text"> <i class="fa fa-car"></i> Car and Body Type </span>
                                <span class="accordion__header--indicator"></span>
                            </div>
                            <div id="bordered_collapseThree" class="collapse accordion__body" data-parent="#accordion-two">
                                <div class="accordion__body--text">


                                    <div class="row">

                                        <div class="col-lg-6 ak-vertical-line">

                                            <select onchange="SentUpdatedInspection(this.id,' car updated ')" id="car-select" name="car" class="package_selection">

                                                <option  value  >  Select Car </option>
                                                <?php $__empty_1 = true; $__currentLoopData = GetCars(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                                                    <option data="<?php echo e($list->car_body_type); ?>" value="<?php echo e($list->car_id); ?>"> <?php echo e($list->car_name); ?> / <?php echo e($list->car_make); ?> / <?php echo e($list->car_plate_number); ?> / <?php echo e($list->car_model); ?> / <?php echo e($list->car_body_type != null ? App\Models\CarBodyType::find( $list->car_body_type )->cby_name : "Body Type Not Selected"); ?>    </option>


                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                                <?php endif; ?>

                                            </select>

                                        </div>



                                        <div class="col-lg-6">

                                            <button class="btn btn-primary" type="button"  onclick="document.getElementById('create_car_model_button').click()"  style="float: right; margin-top: 10px"> Create New </button>

                                        </div>


                                    </div>

                                   <div class="col-lg-12" style="padding-top: 1%">

                                       <div class="row">

                                           <input type="text" onchange="UpdateReport(this.id)" class="form-control col" id="report_mileage" value="<?php echo e(GetQCADN($id)['report_mileage']); ?>" placeholder="Mileage">



                                           <input  list="reports_interior" type="text" onchange="UpdateReport(this.id)"  class="form-control col" id="report_interior" value="<?php echo e(GetQCADN($id)['report_interior']); ?>" placeholder="Interior">

                                           <datalist id="reports_interior">
                                               <option value="Tan">
                                               <option value="Black">
                                               <option value="White">
                                               <option value="Maroon">
                                               <option value="Red">
                                               <option value="Red/black">
                                               <option value="Blue">
                                               <option value="Green">
                                               <option value="Gray">
                                               <option value="Gray/black">
                                               <option value="Brown">
                                               <option value="Dark gray">
                                               <option value="Beige">
                                           </datalist>

                                           <input list="reports_exterior" type="text" onchange="UpdateReport(this.id)"  class="form-control col" id="report_exterior" value="<?php echo e(GetQCADN($id)['report_exterior']); ?>" placeholder="Exterior">
                                           <datalist id="reports_exterior">
                                               <option value="Red">
                                               <option value="Maroon">
                                               <option value="Black">
                                               <option value="White">
                                               <option value="Blue">
                                               <option value="Green">
                                               <option value="Gray">
                                               <option value="Brown">
                                               <option value="Dark gray">
                                               <option value="Beige">
                                               <option value="Sky Blue">


                                           </datalist>



                                           <select class="form-control col" onchange="UpdateReport(this.id)" id="report_gcc" >
                                               <option >Select GCC</option>
                                               <option <?php echo e(GetQCADN($id)['report_gcc']==="Yes"?"Selected":""); ?> value="Yes">Yes</option>
                                               <option  <?php echo e(GetQCADN($id)['report_gcc']==="No"?"Selected":""); ?> value="No">No</option>
                                           </select>

                                       </div>


                                   </div>



                                </div>
                            </div>
                        </div>


                        
                        <div  id="body-inspector-div" style="display: none" class="accordion__item">
                            <div class="accordion__header collapsed" data-toggle="collapse" data-target="#bordered_collapseFour"> <span class="accordion__header--text"> <i class="fa fa-car"></i> Body Inspector </span>
                                <span class="accordion__header--indicator"></span>
                            </div>
                            <div id="bordered_collapseFour" class="collapse accordion__body" data-parent="#accordion-two" >
                                <div id="bordered_collapseFour-div" class="accordion__body--text">

                                    <iframe id="body-inspector" src= <?php echo e(url('/') . "/panel/body-type/canvas"); ?>

                                            frameborder="0" style="overflow:scroll;height:100%;width:100%" height="100%" width="100%"
                                    ></iframe>

                                </div>
                            </div>
                        </div>



                        
                        <div class="accordion__item" id="start_inspection_div" >

                            <div class="accordion__header collapsed" data-toggle="collapse" data-target="#bordered_collapseFive"> <span class="accordion__header--text"><i class="fa fa-tasks "></i> Start Inspection </span>
                                <span class="accordion__header--indicator"></span>
                            </div>
                            <div id="bordered_collapseFive" class="collapse accordion__body" data-parent="#accordion-two">

                                <div class="accordion__body--text">
                                    <div class="row col-lg-12" id="start-inspection">

                                    </div>
                                </div>
                            </div>
                        </div>

                    </form>


                </div>
            </div>
        </div>
    </div>





    <?php echo $__env->make('panel.customers.model.create_model', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('panel.cars.model.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>





<?php $__env->startPush('scripts'); ?>

    <!-- Datatable -->
    <script src="<?php echo e(asset('template_assets')); ?>/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('template_assets')); ?>/js/plugins-init/datatables.init.js"></script>
    <script src="<?php echo e(asset('template_assets')); ?>/vendor/select2/js/select2.full.min.js"></script>



    <script>

        var SITEURL = "<?php echo e(url('/')); ?>";


        var inspect_data ;
        var pusher_status = false;


        var allow_inspection_update = false;
        // let available_select_keys = [];

        var SITEURL = "<?php echo e(url('/')); ?>";


        $("#create_car_model_button").hide();
        $("#create_customer_model_button").hide();




        $("#inspection_start_button").hide();

        // single select box
        $("#package-select").select2();

        $("#customer-select").select2();

        $("#car-select").select2();

        function GetHeadChecks()
        {
            $('#start-inspection').empty();
            $("#inspection_start_button").hide();

            $.ajax({
                type: "GET",
                url:  SITEURL + "/helper/get-head-check-data-by-package-id/"+$("#package-select").val(),
                success: function(data, textStatus, jqXHR){

                    // console.log(data);
                    SetupInspection(data)
                },
                error: function(jqXHR, textStatus, errorThrown){}
            })

        }

        function  UpdateAdditionalNote(id)
        {

            if(allow_inspection_update === true && pusher_status === false) {


                // console.log('updating');
                var note = document.getElementById(id).value;

                if(CheckErrorInspection(note) === true)
                {
                    $.ajax({

                    'url': SITEURL + "/panel/quick-check/additional-note-update/" + '<?php echo e($id); ?>'+'/'+id,
                    'type': 'get',
                    data: {data: note},
                    success: function (data) {
                        console.log(data);
                    }

                    });

                }


            }

        }


        function CheckErrorInspection(note)
        {
            var result = true;
            var arr = note.split(",");

            arr.some(function(element) {

                if(element.length >= 51)
                {
                    Swal.fire('<p style="line-height: 1; font-size: 16px;"> Characters limit upto 50, please decrease this point </p>\n <p  style="font-size: 18px;color: red;" >"'+element+'"</p>');

                    result = false;
                }

            });

            return result;
        }

        function SetupInspection(data)
        {

            // console.log(data);
            if(data.length !== 0)
            {
                $("#inspection_start_button").show();
            }




            var interior = '<label>Interior</label><textarea name="interior" id="interior" onchange="UpdateAdditionalNote(this.id)"  class="form-control" placeholder="Interior Notes, please use comma for separations"><?php echo e(GetQCADN($id)['interior']); ?></textarea>';
            var exterior = '<label>Exterior</label><textarea name="exterior" id="exterior" onchange="UpdateAdditionalNote(this.id)"  class="form-control" placeholder="Exterior Notes, please use comma for separations"><?php echo e(GetQCADN($id)['exterior']); ?></textarea>';
            var mechanical_electrical = '<label>Mechanical Electrical</label><textarea name="mechanical_electrical" onchange="UpdateAdditionalNote(this.id)" id="mechanical_electrical"  class="form-control" placeholder="Mechanical Notes, please use comma for separations"><?php echo e(GetQCADN($id)['mechanical_electrical']); ?></textarea>';
            var test_drive = '<label>Test Drive</label><textarea name="test_drive" id="test_drive" onchange="UpdateAdditionalNote(this.id)"  class="form-control" placeholder="Test Drive Notes, please use comma for separations"><?php echo e(GetQCADN($id)['test_drive']); ?></textarea>';

            document.getElementById('custom_price').value = "<?php echo e(GetQCADN($id)['custom_price']); ?>";

            $('#start-inspection').append(interior);
            $('#start-inspection').append(exterior);
            $('#start-inspection').append(mechanical_electrical);
            $('#start-inspection').append(test_drive);



            var additional = '<label>Additional Notes</label><textarea name="additional_note" id="additional_note" onchange="UpdateAdditionalNote(this.id)" class="form-control" placeholder="Additional Notes, please use comma for separations"><?php echo e(GetQCADN($id)['additional_note']); ?></textarea>';

            $('#start-inspection').append(additional);

            var html1 = "";
            var html2 = "";
            var html3 = "";

            for(var i = 0; i < data.length; i++)
            {
                var html2 = "";
                var html3 = "";

                html1 = '<div  class=" card custom-card col-lg-5">'+
                    '<div class="card-header">'+
                    '<h4 class="card-title">'+data[i].head_name+'</h4>'+
                    '</div>'+
                    '<div class="card-body">'+
                    '<div  class="widget-media">'+
                    '<ul class="timeline">';

                try {

                    for (var j = 0 ; j <  data[i].check_list.length ; j++)
                    {

                        var temp_name = data[i].check_list[j].check_id+'_'+data[i].check_list[j].check_name.split(' ').join('-');
                        // available_select_keys.push(temp_name);
                        var log_name = "\'"+data[i].head_name+' '+data[i].check_list[j].check_name+"\'";

                        var  html2_1 ='<li>'+
                            '<div class="timeline-panel">'+
                            '<div class="media-body">'+
                            '<h5 class="mb-0">'+data[i].check_list[j].check_name+'</h5>'+
                            '<br>'+
                            '</div>'+
                            '<div class="custom-control" style="z-index: auto;">'+
                            '<select onchange="SentUpdatedInspection(this.id,'+log_name+')" class="form-control default-select" id="'+temp_name+'" name="'+temp_name+'">'+
                            '<option value> Select Option </option>';

                        var html2_2 = "";

                        for(var k = 0 ; k < data[i].check_list[j].check_option.length ; k++)
                        {
                            // console.log(data[i].check_list[j].check_option[k],data[i].check_list[j].check_option[k].length);
                            html2_2 += '<option value="'+data[i].check_list[j].check_option[k]+'">'+data[i].check_list[j].check_option[k]+'</option>';
                        }

                        /*'<option value="0"> Check </option>'+
                        '<option value="1"> Not Check </option>'+*/


                        var  html2_3 = '</select>'+
                            '</div>'+
                            '</div>'+
                            '</li>';

                        html2 += html2_1+html2_2+html2_3;

                    }


                }catch (e) {

                }




                html3 =    '</ul>'+
                    '</div>'+
                    '</div>'+
                    '</div>';

                $('#start-inspection').append(html1+html2+html3);


            }

            try {
                UpdateInspectionChecks()
            }catch (e) {

            }




        }

        function GetInspectionId()
        {

            $.ajax({
                type: "GET",
                url:   SITEURL +  "/panel/quick-check/inspection/"+"<?php echo e($id); ?>",
                success: function(data, textStatus, jqXHR){


                    inspect_data = data;

                    UpdateInspection();
                },
                error: function(jqXHR, textStatus, errorThrown){

                }
            })


        }

        function UpdateInspection()
        {

            var data = inspect_data;
            // console.log(data);
            $("#package-select").select2().val(""+data.package_id+"").trigger("change");
            $("#customer-select").select2().val(""+data.customer_id+"").trigger("change");
            $("#car-select").select2().val(""+data.car_id+"").trigger("change");

            console.log('inspect_data:', data);
            console.log('data.car_id:', data.car_id);
            if(data.car_id && !isNaN(data.car_id))
            {
                document.getElementById('body-inspector-div').style.display = "";

                document.getElementById('body-inspector').src =   SITEURL +  "/panel/body-type/canvas/"+data.car_id+"/"+"<?php echo e($id); ?>";

            }else
            {
                document.getElementById('body-inspector-div').style.display = "none";
            }





        }

        function UpdateInspectionChecks()
        {

            document.getElementById('start_inspection_div').setAttribute('onclick','');

            var data = JSON.parse(inspect_data.inspection_data);

            // console.log(data);

            try {

                for (var key in data) {

                    if(data[key]!==null)
                    {
                        // console.log("key " + key + " has value " + data[key]);

                        if(key === "additional_note" || key === "interior" || key === "exterior" || key === "mechanical_electrical" || key === "test_drive" || key === "custom_price")
                        {
                           continue;
                        }

                      /*  console.log("key " + key + " has value " + data[key]);
                        console.log(data[key].length);*/
                        $("#"+key).val(''+data[key]+'').trigger("change");
                    }

                }

            }catch (e) {

                // console.log(e);

            }

            allow_inspection_update = true;


        }

        <?php if(GetInspectionStatusById($id)->end_at !== null): ?>

        function  ContinueInspection()
        {
            ShowLoading();
            $.ajax({
                type: "GET",
                url:   SITEURL +  "/panel/quick-check/continue-inspection/"+<?php echo e($id); ?>,
                success: function(data, textStatus, jqXHR){
                    // console.log(data);
                    location.reload();
                },
                error: function(jqXHR, textStatus, errorThrown){
                }
            })
        }


        <?php else: ?>
        function  EndInspection()
        {
            ShowLoading();
            $.ajax({
                type: "GET",
                url:   SITEURL +  "/panel/quick-check/end-inspection/"+<?php echo e($id); ?>,
                success: function(data, textStatus, jqXHR){
                    console.log(data);
                    window.location.replace("<?php echo e(route('panel.dashboard')); ?>");
                },
                error: function(jqXHR, textStatus, errorThrown){

                }
            })

        }
        <?php endif; ?>


        function  SentUpdatedInspection(id,from= "")
        {

            // console.log(pusher_status);

            if(allow_inspection_update === true && pusher_status === false)
            {
                // console.log("executing...")

                var log_value = $('#'+id+" option:selected").text();
                var log_id = $('#'+id+" option:selected").val();

                console.log('log_value:', log_value);
                console.log('log_id:', log_id);

                if(from === " car updated ")
                {
                   if(log_value!=="  Select Car ")
                   {
                       document.getElementById('body-inspector-div').style.display = "";

                       document.getElementById('body-inspector').src =   SITEURL +  "/panel/body-type/canvas/"+log_id+"/"+"<?php echo e($id); ?>";

                   }else
                   {
                       document.getElementById('body-inspector-div').style.display = "none";
                   }

                }



                var log_msg = "set "+from+" to "+log_value.replace(/\//g, "-");

                var queryString = $('#quick_check_form').serializeArray();

                // console.log(queryString);

                var id = '<?php echo e($id); ?>';

                $.ajax({
                    type: "GET",
                    url:   SITEURL +  "/panel/quick-check/updated/"+id+"/"+log_msg,
                    data: queryString,
                    success: function(data, textStatus, jqXHR){

                        // console.log(data);
                    },
                    error: function(jqXHR, textStatus, errorThrown){

                    }
                })

            }

            // allow_inspection_update = true;



        }

        function selectElement(id, valueToSelect,valueToRemove) {
            let element = document.getElementById(id);
            element.value = valueToSelect;
            element.dispatchEvent(new Event('change'))
        }

        $( document ).ready(function() {
            GetInspectionId();

            $("#package-select").prop("disabled", true);


        });

    </script>

    <script src="https://js.pusher.com/7.2/pusher.min.js"></script>
    <script>

        // Enable pusher logging - don't include this in production
        Pusher.logToConsole = false;

        var pusher = new Pusher('0e6971754bed2be26d59', {
            cluster: 'ap2'
        });

        var channel = pusher.subscribe('inspection-channel');

        channel.bind("App\\Event\\InspectionDataSent", function(data) {
            // console.log(JSON.parse(data.qc_data.inspection_data));
            
            
            if(data.user_id != "<?php echo e(Auth::User()->id); ?>"  && parseInt(data.qc_id) === parseInt("<?php echo e($id); ?>") ) {
                // console.log("okay");
                
                UpdateDataByPusher(JSON.parse(data.qc_data.inspection_data));
            }
        });

        function UpdateDataByPusher(data)
        {

            // var new_selected_keys =  [];

            // console.log(data);
            pusher_status = true;
            // console.log("executing pusher ...")
            event.stopPropagation();




            // console.log(data);

                for (var key in data) {

                    // console.log("key " + key + " has value " + data[key]);
                    // new_selected_keys.push(key);

                    try {

                        if(data[key]!==null)
                        {

                             /* console.log(data[key].length);*/
                            if(key === "car")
                            {
                                if($("#car-select option[value='"+data[key]+"']").length > 0)
                                {
                                    // console.log("found");
                                    $("#car-select").val(''+data[key]+'').trigger("change");

                                }else
                                {
                                    // console.log("n found");
                                    $("#car-select").append(new Option("New Car Added", ""+data[key]+""));
                                    $("#car-select").val(''+data[key]+'').trigger("change");
                                }


                            }else if(key === "customer")
                            {
                                if($("#customer-select option[value='"+data[key]+"']").length > 0)
                                {
                                    $("#customer-select").val(''+data[key]+'').trigger("change");

                                }else
                                {
                                    $("#customer-select").append(new Option("New Customer Added", ""+data[key]+""));
                                    $("#customer-select").val(''+data[key]+'').trigger("change");
                                }


                                // $("#customer-select").val(''+data[key]+'').trigger("change");
                            }
                            else
                            {
                              $("#"+key).val(''+data[key]+'').trigger("change");

                            }

                         }
                        else {
                            // console.log("setting to null "+key+" okay");
                            $("#"+key).val(null).trigger("change");
                        }

                    }catch (e) {
                        // console.log(e);
                    }
                }



            /*console.log(available_select_keys);
            console.log(new_selected_keys);*/


            pusher_status = false;

        }

    </script>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>

        function UpdateReport(id)
        {
            var key_value = document.getElementById(id).value;

            var data = { key: id, value: key_value };

            $.ajax({

                url:    SITEURL + "/panel/quick-check/update-report/"+'<?php echo e($id); ?>',
                data: data,
                type: "GET",
                success: function (data)
                {
                    console.log(data);
                }



            });



        }

    </script>


    <script>

        function ShowLoading()
        {
            Swal.fire('Processing your request, please wait...')
            Swal.showLoading()
        }

    </script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('panel.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mohatigz/public_html/sites/check-first-main/resources/views/panel/quick_check/in-progress.blade.php ENDPATH**/ ?>