<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    
    <meta name="viewport" content="width=1920">
    <meta name="author" content="ThemeMarch">
    <!-- Site Title -->


    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.1/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>


    <title>Report# <?php echo e($report->qc_id); ?></title>


    <script src="<?php echo e(asset('html2pdf/html2pdf.bundle.js')); ?>"></script>

    <style>
        .label {
            color: white;
            padding: 8px;
            font-family: Arial;
            padding: 1px;
        }
        .success {background-color: #05ea4f;} /* Green */
        .info {background-color: #55a0dc;} /* Blue */
        .warning {background-color: #e8e854;} /* Orange */
        .danger {background-color: #f44336;} /* Red */
        .watermark{
            background-image: url(<?php echo e(asset('template_assets/images')); ?>/watermark.png)  !important;
            background-size:100%;
            background-repeat: no-repeat;
            background-position-y: 85%;
        }
        .font-setup{
            font-size: 12px
        }
        li{
            color: #000000;
        }
        .mak-issues{
            width: 50% !important;
        }
        .mak-issues .check-values{
            word-break: break-word;
        }
        .check-values{
            width: 80%;
        }
        /* 2 columns (600px) */
       /* .container .col {
            float: left;
            width: 50%;
        }*/
        ol{
            padding-left: 10%;
        }

        ul{
            padding-left: 10%;
        }
        .two_last_footer
        {
            background-color: #fff;

        }
            .body_type_image{
               /* transform: rotate(270deg);
                width: 220px;
                height: 420px;
                margin-top: -80px;
                padding-top: 30%;
                padding-bottom: 0%;
                padding-right: 0%;
                padding-left: 0%;
                margin-left: -7%;*/

                position:absolute;
                top: 0px;
                left: 0px;

                transform: rotate(270deg);
                width: 220px;
                height: 360px;
                margin-top: -50px;
                padding-top: 0%;
                padding-bottom: 0%;
                padding-right: 0%;
                padding-left: 5%;
                /*margin-left: 25%;*/
                margin-left: 18%;
            }

            html, body { margin: 0; height: 100%;/* overflow: hidden;*/}


            .other-page-headers{
                display: flex;
                height: auto;
                border-bottom-style: solid;
                border-color: blue;
                width: 111%;
                margin-left: -11%;
                margin-bottom: 100px;
            }

            .first-v-line{
                border-right: 2px solid blue;

                width: 33%;
                height: 277px;
                margin-top: 1%;
                /* position: absolute; */
                left: 50%;
                margin-bottom: 1%;
            }

            table{
                height: 15px !important;
            }

            tr,td{
                height: 15px !important;
            }

            td p span{
                font-size: 8px !important;
            }

            td p {
                line-height: 0.7 !important;
            }


            .section_border{
                border-bottom-style: solid;
                border-bottom-color: blue;
                margin-top: 2px;
                margin-bottom: 2px;
            }


            .issues-p{
              line-height: 0;
                overflow-wrap: break-word;
                text-align: left;
                font-size: 12px;
            }

            .issues-p2{
                overflow-wrap: break-word;
                text-align: left;
                font-size: 12px;
            }

            #issue_container{
                /*height: 475px;*/
                width: 100%;
                margin-left: -4px;
            }

            .setting_1{
                margin-block: auto;
                padding-left: 3%;

            }

            .setting_2{
                line-height: 0.8;
            }

            h5{
                color: #e33a3a;
            }

            .adjust_top{

                margin-top: 15px;
                margin-bottom: 15px;
            }

            .background-watermark-page-1 img{
                position: absolute;
                width: 60%;
                height: 270px;
                top: 450px;
                left: 130px;
            }

        .background-watermark-page-o img{
            position: absolute;
            width: 60%;
            height: 270px;
            top: 600px;
            left: 130px;
        }

        .key_color{
            color: blue;
        }

        .vertical-bi{
            /*margin-left: -120px !important;
            writing-mode: vertical-lr;
            transform: rotate(0deg);
            white-space: nowrap;
            text-orientation: upright;
            font-size: 12px;
            font-weight: 900;*/
        }

            #footer_below{

            }

            .bi-image{
                /*margin-left: -100px;*/
                height: 230px;
                /*width: 40px;*/

                width: 20px;
                margin-left: -90px;
            }

</style>


</head>

<body>




<div class="cs-container">

    <div class="cs-invoice_btns cs-hide_print">
        <h3 style="color: red">PDF will start downloading shortly...</h3>
    </div>

    <div class="cs-invoice  cs-style1">

        <div class="cs-invoice_in" id="download_section">


            <div id="top_header" class="col-lg-12">
                <div class="row adjust_top" style="border-bottom-style: solid; height: 73px; border-color: blue; ">

                    <div class="col">
                        <?php echo QrCode::size(65)->generate(WebsiteData()['qr_code_url']); ?>

                    </div>

                    <div class="col" style="    line-height: 0;    margin-left: -35%;    margin-top: 5px;">
                        <p class="font-setup cs-invoice_number cs-primary_color  cs-m0"><b class="cs-primary_color ">Job Card #</b> <span class="key_color">  <?php echo e($report->qc_id); ?> </span> </p>
                        <p class="font-setup cs-invoice_number cs-primary_color  cs-mb5 cs-f16" style="white-space: nowrap"><b class="cs-primary_color ">Tel:</b>  <span class="key_color">  <?php echo e(WebsiteData()['tel']); ?> </span> <b class="cs-primary_color">Mob:</b> <span class="key_color"> <?php echo e(WebsiteData()['mob']); ?> </span>       </p>
                        <p class="font-setup cs-invoice_date cs-primary_color cs-m0"><b class="cs-primary_color ">Issue Date: </b> <span class="key_color">  <?php echo e(date('d-M-Y')); ?> </span> </p>
                        <p class="font-setup cs-invoice_date cs-primary_color cs-m0"><b class="cs-primary_color ">Issue Time: </b> <span class="key_color">  <?php echo e(date('h:i:s A')); ?> </span> </p>

                    </div>

                    <div class="col" style="text-align: right;">

                        <img  style="width: 112px;  height: 55px;" src="<?php echo e(asset('template_assets/images')); ?>/logo.png" alt="Logo">

                        <p style="font-size:10px;margin-right: 3px; font-weight: bold"><?php echo e(WebsiteData()['memo']); ?></p>

                    </div>


                </div>
            </div>
            <div class="background-watermark-page-1">
                <img src="<?php echo e(asset('template_assets/images')); ?>/watermark.png" alt="">
            </div>

            <div class="col-lg-12">

                <div class="row" style="border-bottom-style: solid; border-color: blue; margin-top: -8px;">
                    <div class="col-lg-4" style="border-right-style: solid;    border-color: blue; line-height: 0.8;height: 263px;  margin-top: -7px">

                        <p style="margin-top: 2px !important;"><b class="cs-primary_color ">Package: </b> <span class="key_color"> <?php echo e($report['Package']['package_name'] ?? "N/A"); ?></span>
                        <br>
                            <b>Amount:</b>  <span class="key_color"><?php echo e($price??0); ?></span>
                        </p>


                        <b class="cs-primary_color">Customer Information:</b>
                        <ul style=" list-style-type: circle;">

                            <li>  Name: <span class="key_color"> <?php echo e($report['Customer']['customer_name'] ?? "N/A"); ?> </span></li>
                            <li>  Contact: <span class="key_color"> +<?php echo e((int)$report['Customer']['customer_country_code']??"0"); ?>-<?php echo e((int)$report['Customer']['customer_contact']??"0"); ?> </span></li>
                        </ul>

                        <b class="cs-primary_color">Car Information:</b>
                        <ul style=" list-style-type: circle;     line-height: 0.9;">

                            <li>  Plate# <span class="key_color"> <?php echo e($report['Car']['car_plate_number']  ?? "N/A"); ?> </span> </li>
                            <li>  Make: <span class="key_color"> <?php echo e($report['Car']['car_make'] ?? "N/A"); ?>  </span> </li>
                            <li>  Model: <span class="key_color"> <?php echo e($report['Car']['car_model'] ?? "N/A"); ?> </span> </li>
                            <li>  Year: <span class="key_color"> <?php echo e($report['Car']['car_year'] ?? "N/A"); ?> </span> </li>
                            <li>  Vin: <span class="key_color"> <?php echo e($report['Car']['car_vin_number'] ?? "N/A"); ?> </span> </li>
                            <li>  Mileage: <span class="key_color"> <?php echo e($report['report_mileage'] ?? "N/A"); ?> </span> </li>
                            <li>  Interior: <span class="key_color"> <?php echo e($report['report_interior'] ?? "N/A"); ?> </span> </li>
                            <li>  Exterior: <span class="key_color"> <?php echo e($report['report_exterior'] ?? "N/A"); ?> </span> </li>
                            <li>  GCC:  <span class="key_color"><?php echo e($report['report_gcc'] ?? "N/A"); ?> </span></li>

                        </ul>


                    </div>


                    <div class="col-lg-6" style="    margin-left: 11%;">

                        <p style="
                            font-weight: 700;
                               font-size: 16px;
                            margin-left: 60px;
                            margin-bottom: 200px;
                            margin-top: -8px;
                        ">BODY INSPECTION</p>

                        <img class='body_type_image'  src="<?php echo e(asset('storage/cars-body-type/'.$report['Car']['car_body_type'].'/image/image.png')); ?>"
                        >
                        <img class='body_type_image'  src="<?php echo e(asset('storage/qc_data_images/'.$report->qc_id.'/body_inspector_canvas.png')); ?>"
                        >


                        <div style="margin-left: -40px;">
                            <span class="label info">Part Replaced القطعة &ensp; مبدلة</span>
                            <span class="label success">Paint صبغ</span>
                            <span class="label danger">Filler معجون </span>
                            
                        </div>

                    </div>
                </div>

            </div>


            <!--        item details-->


            <?php

            //            dd($report);
            $list_counter = 1;

            $data_v1['exterior'] = explode(',',$report->exterior);
            $data_v1['interior'] = explode(',',$report->interior);
            $data_v1['mechanical_electrical'] = explode(',',$report->mechanical_electrical);
            $data_v1['test_drive'] = explode(',',$report->test_drive);
            $data_v1['additional_note'] = explode(',',$report->additional_note);

            $data_v1 = array_filter($data_v1);
            $data = json_decode($report['inspection_data']??[]);


            ?>

            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <?php if($key === 'car' || $key === "customer" || $list === null): ?>
                    <?php continue; ?>
                <?php endif; ?>

                <?php

                    $set_key = explode('_', $key);
                    $set_key = end($set_key);
                    $set_key = str_replace('-',' ',$set_key);
                    $set_key = ucwords($set_key);
                $temp_data[]  = $set_key.": ".$list;
                ?>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php

            if(!empty($temp_data))
            {

               // $data_v1['other'] = $temp_data;
            }

            ?>





            <div class="container" id="div_container">
                <div class="row" id="issue_container">


                </div>


            </div>


            <div id="footer_below" style="  width: 751px;  margin-left: 20px;    margin-right: 20px;">

                <div class="cs-note two_last_footer" style="margin-left: -15px"  id="last_two_footer">
                    <div class="cs-note_right">
                        <b class="cs-primary_color" style="color: #000000" > <?php echo str_replace("<p>&nbsp;</p>", "", WebsiteData()['invoice_above_footer']); ?>  </b>

                        <table style="width: 99%;     margin-top: 3px;">

                            <tr>
                                <th style="    border: solid;   width: 157px;    height: 40px;"></th>
                                <th></th>
                                <th style="    border: solid;   width: 174px;    height: 40px;"></th>

                            </tr>
                            <tr>
                                <th><b>Inspector Signature</b></th>
                                <th></th>
                                <th style="float: right;margin-right: 15px"><b>Customer Signature</b></th>
                            </tr>


                        </table>
                    </div>
                </div><!-- .cs-note -->

                <div class="cs-note"  style="      margin-right: 8px;
    margin-left: -15px;  font-size: 13px;background-color: #030a6d; /*margin-top: -4%;*/justify-content:center;text-align: center">
                    <div class="cs-note_right">
                        <b class="cs-primary_color" style="color: #eaeaea" >  <?php echo WebsiteData()['invoice_footer']; ?>  </b>
                    </div>
                </div>

            </div>




            <!-- .cs-note -->



        </div><!-- .cs-note -->

    </div>


</div>


<script src="<?php echo e(asset('html2pdf/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('html2pdf/jspdf.umd.min.js')); ?>"></script>


<script>

    var top_header = document.getElementById('top_header').innerHTML;
    var below_footer = document.getElementById('footer_below').innerHTML;
    var last_head_id = 1;

    var watermark_html = '<div class="background-watermark-page-o">'+
        '<img src="<?php echo e(asset('template_assets/images')); ?>/watermark.png" alt="">'+
        '</div>';

    function generatePDF() {
        const element = document.getElementById('download_section');
        var opt = {
            margin:       1,
            filename:     'myfile.pdf',
            image:        { type: 'jpeg', quality: 0.98 },
            html2canvas:  { scale: 5},
            jsPDF:        {  format: 'a4', orientation: 'portrait' },
            watermark: './images/pngwing.com.png',
        };
        html2pdf().set(opt).from(element).save();


    }

    $( document ).ready(function() {

        var data_v1 = <?php echo json_encode($data_v1) ?>;

        // Prints "name Jean-Luc Picard" followed by "rank Captain"
        var head_counter = 1;
        var point_counter = 1;
        var local_point_counter = 1;
        var page_counter = 1;
        var total_heads = Object.keys(data_v1).length;
        console.log(total_heads);

        var point_at  = 0;
        var point_col  = 0;
        var last_div_id = "";
        var target_diff = 635;
        var diff_a = 0;
        var diff_b = 0;


        console.log(data_v1);

        Object.keys(data_v1).forEach(key1 => {

            console.log(data_v1[key1][0]);
           if(data_v1[key1][0] === "")
           {
               return ;
           }


            var side_l = true;

            var l_counter = 1;
            var r_counter = 1;

           last_div_id = 'head_'+key1+'_'+point_at;

           var  html2 = '<div id="col_'+point_at+'" class="col-lg-12 section_border" style="" >'
                     +'<div class="row" id="head_'+key1+'_'+point_at+'">';



            $('#issue_container').append(html2);

            // console.log(key1);

            Object.keys(data_v1[key1]).every(key2 => {
                // console.log(key2, data_v1[key1][key2]);

                // header footer work

                var diff = trackDistance(point_at)

                // console.log(diff);

                var break_html = '';

                // console.log('new target  diff at least 700 '+(diff-diff_a)+" "+(diff-diff_a >= 800));


                if(diff >= 520 && page_counter === 1)
                {
                    var save_counter = l_counter;
                    l_counter = r_counter+1;
                    r_counter = save_counter-1;
                    console.log('page '+page_counter);



                    break_html = '<div class="col-lg-12 setting_1 footer_div_'+page_counter+'">'+
                        below_footer+
                        '<div class="html2pdf__page-break "></div>'+
                        top_header+
                        watermark_html+
                        '</div>';

                    page_counter++;

                    diff_a = diff;




                }else if((diff-diff_a) >= 1070 && page_counter >= 2)
                {
                    var save_counter = l_counter;
                    l_counter = r_counter+1;
                    r_counter = save_counter-1;

                    console.log('page '+page_counter);

                    break_html = '<div class="col-lg-12 setting_1 footer_div_'+page_counter+'">'+
                        below_footer+
                        '<div class="html2pdf__page-break "></div>'+
                        top_header+
                        watermark_html+
                        '</div>';

                    page_counter++;
                    diff_a = diff;
                    console.log('new target  '+(700*page_counter));
                }


                // header footer work


                if(r_counter === 1)
                {
                    r_counter = Math.round(data_v1[key1].length/2);
                }



                if(side_l === true)
                {

                   var temp_counter = l_counter++;

                    side_l = false;

                }else
                {
                    var temp_counter = ++r_counter;

                    side_l = true;
                }


                var last_div_html  =  "";
                if(head_counter === total_heads &&  temp_counter ===  data_v1[key1].length)
                {
                 last_div_html = "last_div_issue";
                }

                var key_value = "";

                if(temp_counter === 1)
                {

                    var str = key1.replaceAll('_', '  ');
                    str = str.toLowerCase().replace(/\b[a-z]/g, function(letter) {
                        return letter.toUpperCase();
                    });

                    if(str === "Mechanical  Electrical")
                    {
                        str = "Mechanical & Electrical";
                    }


                    key_value = '<h5 class="col-lg-12" style="font-size: 14px"><u>'+str+'</u></h5><br>';
                }


                if(data_v1[key1][key2] === "")
                {
                    return false;
                }



               var html3 = break_html+key_value+'<div class="col-lg-6 setting_1 '+last_div_html+'"><p id="p_'+point_counter+'" class="issues-p" ><b>'+temp_counter+'.</b> '+data_v1[key1][key2].substr(0, 50)+'</p>';
                $('#head_'+key1+'_'+point_at).append(html3);

                /*if(data_v1[key1][key2].length>=49)
                {
                    document.getElementById('p_'+point_counter).style.lineHeight = "0.9";
                    document.getElementById('p_'+point_counter).setAttribute('class','issues-p2');
                }*/

                point_counter++;
                local_point_counter++;
                return true;
            });


            head_counter++;
            point_at++;
            return true;

        });





        if(page_counter === 1)
        {
            var last_div = document.getElementById('div_container').clientHeight;

            document.getElementById('footer_below').style.paddingTop =  (540-last_div)+"px";

        }


        if(page_counter >= 2)
        {

            var last_div_name = 'footer_div_'+(page_counter-1);

            console.log(last_div_name);

            try {

                var last_div = distanceBetweenElements($('.'+last_div_name),$('.last_div_issue'))
            }catch (e) {
                var last_div = distanceBetweenElements($('.'+last_div_name),$('#footer_below'))
            }


            if(page_counter-1 === 2)
            {
                document.getElementById('footer_below').style.paddingTop =  (1035-last_div)+"px";
                document.getElementById('footer_below').style.width =  "90%";
                document.getElementById('footer_below').style.marginLeft =  "20px";
            }else
            {

                document.getElementById('footer_below').style.paddingTop =  (1055-last_div)+"px";
                document.getElementById('footer_below').style.width =  "96%";
                document.getElementById('footer_below').style.marginLeft =  "25px";
            }
        }







        generatePDF();

    });




    function trackDistance(pointer)
    {

        var distance  = 0

          for(var i = 0; i < pointer+1; i++)
          {

              distance += document.getElementById("col_"+i).clientHeight;

          }

      return distance;


    }


    function distanceBetweenElements(elementOne, elementTwo) {
        let distance = -1;

        const x1 = elementOne.offset().top;
        const y1 = elementOne.offset().left;
        const x2 = elementTwo.offset().top;
        const y2 = elementTwo.offset().left;
        const xDistance = x1 - x2;
        // const yDistance = y1 - y2;
        const yDistance = 0;

        distance = Math.sqrt(
            (xDistance * xDistance) + (yDistance * yDistance)
        );

        return distance;
    }



</script>


</body>
</html>
<?php /**PATH /home/mohatigz/public_html/sites/check-first-main/resources/views/report/pdf.blade.php ENDPATH**/ ?>