<!doctype html>
<html lang="">

<head>
	<title>Check First | Body Inspection</title>


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">


	<link rel="stylesheet" href="<?php echo e(asset('body_inspector_canvas')); ?>/css/styles.css">

    <style>
        body {
            margin: 0;
            font-family: Arial, Helvetica, sans-serif;
        }

        .topnav {
            overflow: hidden;
            background-color: #333;
        }

        .topnav a {
            float: left;
            display: block;
            color: #f2f2f2;
            text-align: center;
            padding: 14px 16px;
            text-decoration: none;
            font-size: 17px;
        }

        .topnav a:hover {
            background-color: #ddd;
            color: black;
        }

        .topnav a.active {
            background-color: #04AA6D;
            color: white;
        }

        .topnav .icon {
            display: none;
        }

        @media  screen and (max-width: 600px) {
            .topnav a:not(:first-child) {display: none;}
            .topnav a.icon {
                float: right;
                display: block;
            }
        }

        @media  screen and (max-width: 600px) {
            .topnav.responsive {position: relative;}
            .topnav.responsive .icon {
                position: absolute;
                right: 0;
                top: 0;
            }
            .topnav.responsive a {
                float: none;
                display: block;
                text-align: left;
            }
        }
    </style>

    <style>

        body {

        }


        #myCanvas{
            <?php if(Storage::exists('/public/qc_data_images/'.$qc_id.'/body_inspector_canvas.png')): ?>
            background-image: url('/storage/qc_data_images/<?php echo e($qc_id); ?>/body_inspector_canvas.png');
            <?php else: ?>
            
            <?php endif; ?>

            /*background-color: #ffffff;*/
            background-size: contain;
            background-repeat: no-repeat;
            background-size: 275px 550px;
            /*border: solid 3px #000000;*/
            width: 100%;
        }

    </style>

    <style>
        .slidecontainer {
            width: 100%;
        }

        .slider {
            -webkit-appearance: none;
            width: 100%;
            height: 25px;
            background: #d3d3d3;
            outline: none;
            opacity: 0.7;
            -webkit-transition: .2s;
            transition: opacity .2s;
        }

        .slider:hover {
            opacity: 1;
        }

        .slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 25px;
            height: 25px;
            background: #04AA6D;
            cursor: pointer;
        }

        .slider::-moz-range-thumb {
            width: 25px;
            height: 25px;
            background: #04AA6D;
            cursor: pointer;
        }
    </style>

    <style>


        @media  only screen and (max-width: 933px) {
            .color-code{
                margin-top: 2%;
            }
        }


        @media  only screen and (max-width: 880px) {
            .color-code{
                margin-top: 5%;
            }
        }

        .dropbtn {
            background-color: #4CAF50;
            color: white;
            padding: 16px;
            font-size: 16px;
            border: none;
            cursor: pointer;
        }

        /*.dropdown {*/
        /*    position: relative;*/
        /*    display: inline-block;*/
        /*}*/

        .dropdown-content {
            display: none;
            position: absolute;
            background-color: unset;
            min-width: 160px;
            box-shadow: unset;
            z-index: 1;
        }

        .dropdown-content a {
            color: black;
            padding: 12px 16px;
            text-decoration: none;
            display: block;
        }

        .dropdown-content a:hover {background-color: #f1f1f1}

        .dropdown:hover .dropdown-content {
            display: inline-grid;
            align-items: center;
            margin: 12px;
        }

        .dropdown:hover .dropbtn {
            background-color: #3e8e41;
        }
        #colors{
            display: flex;
        }

        ion-icon{
            font-size: 12px
        }

        .label {
            color: white;
            padding: 8px;
            font-family: Arial;
            padding: 1px;
        }
        .success {background-color: #05ea4f;} /* Green */
        .info {background-color: #55a0dc;} /* Blue */
        .warning {background-color: #e8e854;} /* Orange */
        .danger {background-color: #f44336;} /* Red */

    </style>

</head>


<body style="margin: 0;">



	<div id="page">



        <div class="topnav" id="myTopnav" style="margin-bottom: 16px;/*height: 155px;*/">

            <div id="toolbar">

                <div class="tooloption" id="colors" >
                </div>

                <div hidden id="eraser" class="drawTool" style="">
                    <ion-icon name="water-outline"></ion-icon> Eraser
                </div>

                <div id="filldrip" class="drawTool" style="display:none">
                    <i  class="fa fa-fill-drip"></i>
                </div>

                <div hidden id="brush" class="drawTool">
                    <ion-icon class="ion-icon" name="brush-outline"></ion-icon> Pen
                </div>

                <div onclick="addCross()" id="select-cross" class="drawTool">
                    <ion-icon class="ion-icon" name="close-outline"></ion-icon> Cross
                </div>

                <div hidden onclick="addCircle()" id="select-circle" class="drawTool">
                    <ion-icon class="ion-icon" name="ellipse-outline"></ion-icon> Circle
                </div>

                <div hidden onclick="addBox()" class="drawTool">
                    <ion-icon class="ion-icon" name="tablet-landscape-outline"></ion-icon> Box
                </div>

                <div hidden onclick="addLine()" class="drawTool">
                    <ion-icon class="ion-icon" name="remove-outline"></ion-icon> Line
                </div>

                <div hidden onclick="addText()" class="drawTool">
                    <ion-icon class="ion-icon" name="text-outline"></ion-icon> Text
                </div>

                <div id="clearImage" onclick="RemoveImage()" class="drawTool">
                    <ion-icon name="nuclear-outline"></ion-icon>  Clear
                </div>

                <div  id="btn_convert1" class="drawTool">
                    <ion-icon name="cloud-download-outline"></ion-icon>  Save
                </div>

                <div id="undo" class="drawTool">
                    <ion-icon name="arrow-undo-outline"></ion-icon> Undo
                </div>

                <div id="restore" class="drawTool">
                    <ion-icon name="arrow-redo-outline"></ion-icon> Redo
                </div>

               <div style="margin-top: 3%;display: none">
                   <div class="tooloption" id="rad">
                       Radius Size
                       <span id="radval">3</span>
                       <div id="decrad" class="radcontrol">-</div>
                       <div id="incrad" class="radcontrol">+</div>
                   </div>

                   <div class="tooloption" >
                       Size <span id="size_value">15</span>
                       <div onclick="getSize('size','-')" class="radcontrol">-</div>
                       <div onclick="getSize('size','+')" class="radcontrol">+</div>
                       <input style="display:none" type="range" min="1" max="50" id="size" value="15">

                   </div>
               </div>

                <div class="clear"></div>
                </div>

            <div class="color-code" style="float: left;margin-bottom: 1%;margin-right: 1%">

                <span class="label danger"> Filler</span>
                <span class="label success">Cosmetic Paint</span>
                <span class="label info">Part Replaced</span>
            </div>


        </div>


        <div id="canvasWrapper" style="background-image: url('<?php echo e(url('/')); ?>/storage/cars-body-type/<?php echo e($body_type->cby_id); ?>/image/<?php echo e($body_type->cby_image); ?>');
            background-repeat: round; ">
			<canvas id="myCanvas">
				Sorry, your browser does not support HTML5 canvas
			</canvas>

		</div>


		<div style="/*display:none*/" id="previewImg">
		</div>

	</div>

    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
	<script src="<?php echo e(asset('body_inspector_canvas')); ?>/scripts/html2canvas.js" type="text/javascript"></script>
	<script>
		document.getElementById("btn_convert1").addEventListener("click", function() {

            var strMime = "image/png";
            var canvas = document.getElementsByTagName('canvas')[0];
          /*  var link = document.createElement("a");
            link.href = canvas.toDataURL(strMime);
            link.download = 'test1.png';
            link.click();*/


                var file = dataURLtoFile(canvas.toDataURL(),'image.png');


                let formData = new FormData();
                formData.append('image',file);


                formData.append('qc_id','<?php echo e($qc_id); ?>');
                formData.append('_token','<?php echo e(csrf_token()); ?>');

                console.log(formData);

                $.ajax({

                    url: "<?php echo e(route('panel.quick-check.inspection.image.upload')); ?>",
                    type: "POST",
                    contentType: false,
                    processData: false,
                    data: formData,
                    success: function(data, textStatus, jqXHR){

                        Swal.fire({
                            position: 'top-end',
                            icon: 'success',
                            title: 'Your work has been saved',
                            showConfirmButton: false,
                            timer: 1500
                        })

                        console.log(data);
                    },
                    error: function(jqXHR, textStatus, errorThrown){
                        console.log(jqXHR, textStatus, errorThrown);
                    }

			});






		});

        function  RemoveImage()
        {

            let formData = new FormData();
            formData.append('qc_id','<?php echo e($qc_id); ?>');
            formData.append('_token','<?php echo e(csrf_token()); ?>');


            $.ajax({

                url: "<?php echo e(route('panel.quick-check.inspection.image.remove')); ?>",
                type: "POST",
                contentType: false,
                processData: false,
                data: formData,
                success: function(data, textStatus, jqXHR){

                    Swal.fire({
                        title: 'Do you want to reset the image?',
                        showDenyButton: true,
                        showCancelButton: true,
                        confirmButtonText: 'Reset',
                        denyButtonText: `Don't Reset`,
                    }).then((result) => {
                        /* Read more about isConfirmed, isDenied below */
                        if (result.isConfirmed) {
                            window.location.reload();
                            Swal.fire('Reset!', '', 'success')

                        } else if (result.isDenied) {
                            Swal.fire('Reset Abrot', '', 'info')
                        }
                    })


                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(jqXHR, textStatus, errorThrown);
                }
            })

        }

        function dataURLtoFile(dataurl, filename) {

            var arr = dataurl.split(','),
                mime = arr[0].match(/:(.*?);/)[1],
                bstr = atob(arr[1]),
                n = bstr.length,
                u8arr = new Uint8Array(n);

            while(n--){
                u8arr[n] = bstr.charCodeAt(n);
            }

            return new File([u8arr], filename, {type:mime});
        }

	</script>
	<script type="text/javascript">
		function onReady(callback) {
			var intervalID = window.setInterval(checkReady, 1000);

			function checkReady() {
				if (document.getElementsByTagName('body')[0] !== undefined) {
					window.clearInterval(intervalID);
					callback.call(this);
				}
			}
		}

		function show(id, value) {
			document.getElementById(id).style.display = value ? 'block' : 'none';
		}

		onReady(function () {
			show('page', true);
			show('loading', false);
		});


	</script>
	<script type="text/javascript" src="<?php echo e(asset('body_inspector_canvas')); ?>/sketchpad.js"></script>

	<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
	<script>
	/*	function resize(){
			$("#myCanvas").outerHeight($(window).height()-$("#myCanvas").offset().top- Math.abs($("#myCanvas").outerHeight(true) - $("#myCanvas").outerHeight()));
		}
		$(document).ready(function(){
			resize();
			$(window).on("resize", function(){
				resize();
			});
		});


		function draw() {
			var c = document.getElementById("myCanvas");
			var ctx = c.getContext("2d");
			c.width = document.body.clientWidth; // Remove .style from both
			c.height = document.body.clientHeight;
			ctx.fillRect(100, 50, 100, 75); // fillRect post setting size
		}*/

/*	var c = document.getElementById("myCanvas");
	var ctx = c.getContext("2d");
	var img = document.getElementById("taxi");
	ctx.drawImage(10,10,10, 250, 300);*/
    // 272px 550px;

	$(document).ready(function(){
		const canvas = document.getElementById('myCanvas')
		canvas.width = 272
		canvas.height = 550
	});

	$(document).ready(function(){
		$(document).keydown(function(event) {
			if (event.ctrlKey==true && (event.which == '61' || event.which == '107' || event.which == '173' || event.which == '109'  || event.which == '187'  || event.which == '189'  ) ) {
				alert('disabling zooming');
				event.preventDefault();
				// 107 Num Key  +
				//109 Num Key  -
				//173 Min Key  hyphen/underscor Hey
				// 61 Plus key  +/=
			}
		});

		$(window).bind('mousewheel DOMMouseScroll', function (event) {
			if (event.ctrlKey == true) {
				alert('disabling zooming');
				event.preventDefault();
			}
		});
	});

	$(document).on("mousedown focus", "input, textarea, select", function() {
		$('meta[name=viewport]').remove();
		$('head').append('<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">');
	});
	$(document).on("blur", "input, textarea, select", function() {
		$('meta[name=viewport]').remove();
		$('head').append('<meta name="viewport" content="width=device-width, initial-scale=1">');
	});

	</script>

    <script>
        function myFunction() {
            var x = document.getElementById("myTopnav");
            if (x.className === "topnav") {
                x.className += " responsive";
            } else {
                x.className = "topnav";
            }
        }
    </script>

    <script>


      function getSize(size_id,action)
      {
          var size_value = parseInt(document.getElementById(size_id).value);

          // console.log(size_value,action);

          if(action==='+' && size_value < 30 )
          {
              size +=  1;
              document.getElementById('size_value').innerText = size;
              document.getElementById(size_id).value = size;
          }
          else  if(action==='-' && size > 0 )
          {
              size -=  1;
              document.getElementById('size_value').innerText = size;
              document.getElementById(size_id).value = size;
          }



      }

      function addCross()
      {

          eraserOn = false;
          bgFillOn = false;
          brushOn = false;
          crossOn = true;
          circleOn = false;
          boxOn = false;
          lineOn = false;
          textOn =false;

          deselectTool();

          if(crossOn===true)
          {
              console.log('here');

              var mouseX, mouseY;

              canvas.addEventListener("mouseup", mouseUp, true);

              function drawX(x, y) {
                  if(crossOn===true) {

                      console.log(2);
                      context.beginPath();

                      context.moveTo(x - Math.round(size), y - Math.round(size));
                      context.lineTo(x + Math.round(size), y + Math.round(size));
                      context.stroke();

                      context.moveTo(x + Math.round(size), y - Math.round(size));
                      context.lineTo(x - Math.round(size), y + Math.round(size));
                      context.stroke();
                  }
              }

              function mouseUp(e) {
                  if(crossOn===true)
                  {
                      mouseX = e.pageX - canvas.offsetLeft;
                      mouseY = e.pageY - canvas.offsetTop;
                      drawX(mouseX, mouseY);
                  }

              }
          }

      }

      function addCircle()
      {
          eraserOn = false;
          bgFillOn = false;
          brushOn = false;
          crossOn = false
          circleOn = true;
          boxOn = false;
          lineOn = false;
          textOn =false;

          if(circleOn===true)
          {
              console.log('here');

              var mouseX, mouseY;

              canvas.addEventListener("mouseup", mouseUp, true);

              function drawX(x, y) {
                  if(circleOn===true) {

                      console.log(2);
                      context.beginPath();

                      context.arc(x, y, Math.round(size), 0, 2 * Math.PI);
                      context.stroke();
                  }
              }

              function mouseUp(e) {
                  if(circleOn===true)
                  {
                      mouseX = e.pageX - canvas.offsetLeft;
                      mouseY = e.pageY - canvas.offsetTop;
                      drawX(mouseX, mouseY);
                  }

              }
          }

      }

      function addBox()
      {
          eraserOn = false;
          bgFillOn = false;
          brushOn = false;
          crossOn = false
          circleOn = false;
          boxOn = true;
          lineOn = false;
          textOn =false;

          if(boxOn===true)
          {
              console.log('here');

              var mouseX, mouseY;

              canvas.addEventListener("mouseup", mouseUp, true);

              function drawX(x, y) {
                  if(boxOn===true) {

                      console.log(2);
                      context.beginPath();

                      context.rect(x, y, Math.round(size), Math.round(size));
                      context.stroke();
                  }
              }

              function mouseUp(e) {
                  if(boxOn===true)
                  {
                      mouseX = e.pageX - canvas.offsetLeft;
                      mouseY = e.pageY - canvas.offsetTop;
                      drawX(mouseX, mouseY);
                  }

              }
          }

      }


      function addText()
      {
          eraserOn = false;
          bgFillOn = false;
          brushOn = false;
          crossOn = false
          circleOn = false;
          boxOn = false;
          lineOn = false;
          textOn = true;

          if(textOn===true)
          {
              console.log('here');

              var mouseX, mouseY;

              canvas.addEventListener("mouseup", mouseUp, true);

              function drawX(x, y) {
                  if(textOn===true) {

                      Swal.fire({
                          title: "Type",
                          text: "Write something interesting:",
                          input: 'text',
                          showCancelButton: true
                      }).then((result) => {
                          if (result.value) {

                              // set the text
                              context.font = Math.round(size).toString()+"px Arial";
                              context.fillText(result.value,x, y); // text and position

                          }
                      });


                  }
              }

              function mouseUp(e) {
                  if(textOn===true)
                  {
                      mouseX = e.pageX - canvas.offsetLeft;
                      mouseY = e.pageY - canvas.offsetTop;
                      drawX(mouseX, mouseY);
                  }

              }
          }

      }



      function addLine()
      {
          var x,y,x1,y1;
          eraserOn = false;
          bgFillOn = false;
          brushOn = false;
          crossOn = false;
          circleOn = false;
          boxOn = false;
          lineOn = true;
          textOn =false;

          deselectTool();

          if(lineOn===true)
          {
              console.log('Line');

              var mouseX, mouseY;

              canvas.addEventListener("mouseup", mouseUp, true);
              canvas.addEventListener("mousedown", mouseDown, true);

              function drawX() {
                  if(lineOn===true) {

                      // Begin the path
                      context.beginPath();

                      // Starting point
                      context.moveTo(x, y);
                      context.stroke();
                      // End point
                      context.lineTo(x1, y1);

                      context.stroke();



                  }
              }

              function mouseUp(e) {
                  if(lineOn===true)
                  {
                      console.log('mouse up');
                      x = e.pageX - canvas.offsetLeft;
                      y = e.pageY - canvas.offsetTop;
                      drawX();



                  }

              }

              function mouseDown(e) {
                  if(lineOn===true)
                  {
                      console.log('mouse down');
                      x1 = e.pageX - canvas.offsetLeft;
                      y1 = e.pageY - canvas.offsetTop;

                  }

              }
          }

      }




      $( document ).ready(function() {
          setRadius(1);
          document.getElementById('select-cross').click();
      });


    </script>

</body>


</html>

<div id="loading"></div>
<?php /**PATH /home/mohatigz/public_html/sites/check-first-main/resources/views/panel/car_body_types/canvas.blade.php ENDPATH**/ ?>