<?php


use App\Event\InspectionDataSent;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\FullCalenderController;
use App\Http\Controllers\Panel\BodyTypeController;
use App\Http\Controllers\Panel\CarsController;
use App\Http\Controllers\Panel\QuickCheckController;
use Carbon\Carbon;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Panel\DashboardController;
use App\Http\Controllers\Auth\LoginController;
use \App\Http\Controllers\DataController;
use \App\Http\Controllers\PackageController;
use Pusher\Pusher;
use Twilio\Rest\Client;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('', function () {

    if(Auth::check())
    {
        return redirect(route('panel.dashboard'));
    }else
    {
        return view('auth/login');
    }

});

Route::group(['prefix'=>'temp-api','as'=>'temp-api'],function (){

    Route::get('manage',[QuickCheckController::class,'ManageAPI'])->name('inspection.manage');

    Route::get('report/{id}',[\App\Http\Controllers\ReportsController::class,"ReportAPI"])->name('get-by-id');


});

Route::group( ['prefix'=>'panel','as'=>'panel.','middleware' => ['auth']], function () {


    Route::group( ['prefix'=>'profile','as'=>'profile.'], function () {
        Route::get('', [UserController::class, 'Profile'])->name('get');
        Route::post('update', [UserController::class, 'ProfileUpdate'])->name('update');
    });


    Route::get('calender',function(){

        $pageTitle = "Calender";
        return  view('panel.calender.full_calender',compact('pageTitle'));
    })->name('calender');

    Route::get('sms-sender/{id}',function($id)
    {
        SMSSender($id);
    });

    Route::get('dashboard', [DashboardController::class, 'Dashboard'])->name('dashboard');

    Route::resource('roles', RoleController::class);


    Route::resource('users', UserController::class);
    Route::post('users/{id}/updated',[UserController::class,'update']);
    Route::post('users/{id}/deleted',[UserController::class,'destroy']);

    Route::group( ['prefix'=>'data','as'=>'data.'], function () {

        Route::get('', [DataController::class,'Index'] )->name('index');
        Route::post('head-created' , [DataController::class,'HeadCreated'] )->name('head.created');
        Route::post('head-updated/{head_id}' , [DataController::class,'HeadUpdated'] )->name('head.updated');
        Route::post('check-created' , [DataController::class,'CheckCreated'] )->name('check.created');
        Route::post('check-update/{head_id}' , [DataController::class,'CheckUpdated'] )->name('check.updated');
        Route::get('check-edit/{head_id}' , [DataController::class,'EditCheckListByHead'] )->name('check.edit.by.head');
        Route::post('destroy-head/{head_id}' , [DataController::class,'DestroyHead'] )->name('head.destroy');

        Route::get('check', function(){

            return view('panel.data.check_list');

        })->name('check');

    });

    Route::group( ['prefix'=>'package','as'=>'package.'], function () {

        Route::get('', [PackageController::class,'Index'] )->name('index');
        Route::post('created', [PackageController::class,'Create'] )->name('created');
        Route::get('view/{package_id}', [PackageController::class,'GetPackageById'] )->name('view');
        Route::post('updated/{package_id}', [PackageController::class,'Updated'] )->name('updated');
        Route::post('destroy/{package_id}', [PackageController::class,'Destroy'] )->name('destroy');


    });

    Route::group( ['prefix'=>'customer','as'=>'customer.'], function () {

        Route::get('', [CustomerController::class,'Index'] )->name('index');
        Route::post('created', [CustomerController::class,'Created'] )->name('created');
        Route::post('updated/{customer_id}', [CustomerController::class,'Updated'] )->name('updated');
        Route::post('destroy/{customer_id}', [CustomerController::class,'Destroy'] )->name('destroy');
        Route::get('get-by-email/{email}/{id}', [CustomerController::class,'GetCustomerByEmail'] )->name('get.by.email');
        Route::get('get-by-contact/{code}/{contact}/{id}', [CustomerController::class,'GetCustomerByContact'] )->name('get.by.contact');






    });

    Route::group( ['prefix'=>'cars','as'=>'car.'], function () {

        Route::get('', [CarsController::class,'Index'] )->name('index');
        Route::post('created', [CarsController::class,'Created'] )->name('created');
        Route::post('updated/{car_id}', [CarsController::class,'Updated'] )->name('updated');
        Route::post('destroy/{car_id}', [CarsController::class,'Destroy'] )->name('destroy');
        Route::get('get-by-plate-number/{plate_number}/{id}', [CarsController::class,'GetCarByNumberPlate'] )->name('get-by-plate-number');

    });

    Route::group( ['prefix'=>'body-type','as'=>'body-type.'], function () {

        Route::get('', [BodyTypeController::class,'Index'] )->name('index');
        Route::post('created', [BodyTypeController::class,'Created'] )->name('created');
        Route::post('updated/{cby_id}', [BodyTypeController::class,'Updated'] )->name('updated');
        Route::post('destroy/{cby_id}', [BodyTypeController::class,'Destroy'] )->name('destroy');
        Route::get('get-by-name/{cby_name}/{id}', [BodyTypeController::class,'GetByName'] )->name('get.by.name');
        Route::get('canvas/{id}/{qc_id}', [BodyTypeController::class,'Canvas'] )->name('body.type.canvas');

    });

    Route::group( ['prefix'=>'quick-check','as'=>'quick-check.'], function () {

        Route::get('',[QuickCheckController::class,'Index'])->name('index');
        Route::get('inspection/{id}',[QuickCheckController::class,'InspectionById'])->name('inspection.by.id');
        Route::post('created',[QuickCheckController::class,'Created'])->name('created');
        Route::get('in-progress/{id}',[QuickCheckController::class,'InProgress'])->name('inprogress');
        Route::get('end-inspection/{id}',[QuickCheckController::class,'EndInspection'])->name('end.inspection');
        Route::get('continue-inspection/{id}',[QuickCheckController::class,'ContinueInspection'])->name('continue.inspection');
        Route::get('manage',[QuickCheckController::class,'Manage'])->name('inspection.manage');
        Route::post('destroy/{id}',[QuickCheckController::class,'Destroy'])->name('inspection.destroy');
        Route::post('image-upload',[QuickCheckController::class,'ImageUpload'])->name('inspection.image.upload');
        Route::post('image-remove',[QuickCheckController::class,'ImageRemove'])->name('inspection.image.remove');
        Route::get('updated/{id}/{log}',[QuickCheckController::class,'Updated'])->name('inspection.updated');
        Route::get('logs/{id}',[QuickCheckController::class,'Logs'])->name('inspection.logs');
        Route::get('additional-note-update/{id}/{section}',[QuickCheckController::class,'AdditionalNoteUpdate'])->name('additional-note-update');
        Route::get('update-report/{id}',[QuickCheckController::class,'UpdateReport'])->name('update.report');

    });


    Route::group(['prefix'=>'setup','as'=>'setup.'],function(){

        Route::get('',[\App\Http\Controllers\Panel\SetupController::class,'Index'])->name('index');
        Route::post('update',[\App\Http\Controllers\Panel\SetupController::class,'Update'])->name('update');

    });


    Route::group(['prefix'=>'sms','as'=>'sms.'],function(){

        Route::get('logs',function(){

            $sms_logs = \App\Models\SmsLog::orderBy('id','desc')->get();
            return view('panel.sms.logs',compact('sms_logs'));

        })->name('logs');


    });




});

Route::group(['prefix'=>'report','as'=>'report.'],function(){


    Route::get('get/{id}/{action?}',[\App\Http\Controllers\ReportsController::class,"GetReport"])->name('get-by-id');
    Route::get('',function(){

        return view('report.index');

    });

});

Route::group( ['prefix'=>'helper','as'=>'helper.','middleware' => ['auth']], function () {

    Route::get('username-generator/{email}', function($email = null)
    {
        if(!empty($email))
        {
            return UsernameGenerator($email);
        }

        return "";


    })->name('username.generator');

    Route::get('username-validator/{username}/{user_id}', function($username = null, $user_id = null)
    {
        if(!empty($username) || !empty($user_id))
        {
            return UsernameValidator($username, $user_id);
        }

        return "";


    })->name('username.generator');

    Route::get('email-validator/{email}/{user_id}', function($email = null, $user_id = null)
    {
        if(!empty($email) || !empty($user_id))
        {
            return EmailValidator($email, $user_id);
        }

        return "";


    })->name('username.generator');

    Route::get('contact-validator/{code}/{contact}/{user_id}', function($code = null,$contact = null, $user_id = null)
    {
        if(!empty($code) && !empty($contact) && !empty($user_id) )
        {
          return  MobileNumberValidator($code, $contact, $user_id);

        }

        return false;


    })->name('contact.validator');

    Route::get('get-head-check-data-by-package-id/{package_id}' , function($package_id = null)
    {
            return GetHeadCheckDataByPackage($package_id);
    });

    Route::get('get-car-model/{make}',function ($make)
    {
        return response(GetCarModelByMake($make),200);
    });

    Route::get('get-car-year/{make}/{model}',function ($make,$model)
    {
        return response(GetCarYearByModel($make,$model),200);
    });


});

Route::middleware('auth')->get('fullcalender', [FullCalenderController::class, 'index']);

Route::middleware('auth')->post('fullcalenderAjax', [FullCalenderController::class, 'ajax']);

Auth::routes(['register' => false]);

Route::get('get-logout',[UserController::class,'GetLogout'])->name('get.logout');

//Route::get('/panel/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

