
<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
    <!-- Meta Tags -->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
{{--    <meta name="viewport" content="width=device-width, initial-scale=1">--}}
    <meta name="viewport" content="width=1920">
    <meta name="author" content="ThemeMarch">
    <!-- Site Title -->

    <title>Report# {{$report->qc_id}}</title>
    <link rel="stylesheet" href="{{asset('report_template')}}/assets/css/style.css">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.1/dist/jquery.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

    <style>

        .label {
            color: white;
            padding: 8px;
            font-family: Arial;
            padding: 1px;
        }
        .success {background-color: #05ea4f;} /* Green */
        .info {background-color: #55a0dc;} /* Blue */
        .warning {background-color: #e8e854;} /* Orange */
        .danger {background-color: #f44336;} /* Red */

        .watermark{
            background-image: url({{asset('template_assets/images')}}/watermark.png)  !important;
            background-size:100%;

        }

        li{
            color: #000000;

        }

        .mak-issues{
            width: 50% !important;
        }

        .mak-issues .check-values{
            word-break: break-word;
        }

        .check-values{
            width: 80%;
        }


        /* 2 columns (600px) */
            .container .col {
                float: left;
                width: 50%;
            }

        ul{
            padding-left: 10%;

        }


        .two_last_footer
          {

            /*font-size: 13px;
            margin-top: 10px;
            justify-content:center;
            border-top: 3px solid;
            border-left: 3px solid;
            border-right: 3px solid;
            margin-left: 15px;
            margin-right: 15px;

            text-align: center*/

            background-color: #fff;


          }


        .body_type_image{
            transform: rotate(270deg);
            width: 220px;
            height: 360px;
            margin-top: -85px;
            padding-top: 0%;
            padding-bottom: 0%;
            padding-right: 0%;
            /*padding-left: 5%;*/
            /*margin-left: 25%;*/
            margin-left: 18%;
        }

        h5{
            color: #e33a3a;
        }

        .issues-p{
            line-height: 0;
            overflow-wrap: break-word;
            text-align: left;
        }

        .col-6{
            margin-block: auto;
        }

        .body_type_image_div{

            background-image: url({{asset('storage/cars-body-type/'.$report['Car']['car_body_type'].'/image/image.png')}});
            background-repeat: round;

        }

    </style>


</head>

<body>

<div class="cs-container ">

    <div class="cs-invoice_btns cs-hide_print">

        <a href="{{url()->current().'/pdf'}}" class="cs-invoice_btn cs-color2">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" viewBox="0 0 512 512"><title>Download</title><path d="M336 176h40a40 40 0 0140 40v208a40 40 0 01-40 40H136a40 40 0 01-40-40V216a40 40 0 0140-40h40" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32"/><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M176 272l80 80 80-80M256 48v288"/></svg>
            <span>Download</span>
        </a>

    </div>

    <div class="cs-invoice  cs-style1">

        <div class="cs-invoice_in watermark" id="download_section">



            <div class="cs-invoice_head cs-type1 cs-mb25" style="
    margin-top: -35px;
">



<div class="">
    {!! QrCode::size(90)->generate(WebsiteData()['qr_code_url']) !!}
</div>

<div class="cs-invoice_left" style="margin-left: -265px; padding-left: 15px;">
    <p class="cs-invoice_number cs-primary_color cs-m0"><b class="cs-primary_color">Job Card #</b> {{$report->qc_id}}</p>
    <p style="white-space: nowrap" class="cs-invoice_number cs-primary_color cs-mb5 cs-f16">
        <b class="cs-primary_color">Tel:</b> {{WebsiteData()['tel']}} 
        <b class="cs-primary_color">Mob:</b> {{WebsiteData()['mob']}}
    </p>
     <p class="cs-invoice_date cs-primary_color cs-m0">
        <b class="cs-primary_color">Issue Date: </b> 
        {{ $report['start_at'] ? date('d-M-Y h:i:s A', strtotime($report['start_at'])) : 'N/A' }}
    </p>
    <p class="cs-invoice_date cs-primary_color cs-m0">
        <b class="cs-primary_color">Print Date: </b> {{date('d-M-Y h:i:s A')}}
    </p>
  
</div>

<div class="cs-invoice_right cs-text_right">
    <div class="cs-logo cs-mb5">
        <img style="width: 150px; height: 85px;" src="{{asset('template_assets/images')}}/logo.png" alt="Logo">
        <p style="font-size:10px;margin-right: 20px; font-weight: bold">{{WebsiteData()['memo']}}</p>
    </div>
</div>

</div>

<ul class="cs-grid_row cs-col_3 cs-mb10" style="display: flex; justify-content: space-between; border-bottom: 3px solid #0b36e0">
    <li class="cs-mb20" style="border-right-style: solid; border-color: blue; width: 40%;">
        <b class="cs-primary_color">Customer Information:</b>
        <ul style="list-style-type: circle;">
            <li>Package: {{$report['Package']['package_name'] ?? "N/A"}}</li>
            <li>Name: {{$report['Customer']['customer_name'] ?? "N/A" }}</li>
            <li>Contact: +{{ (int)$report['Customer']['customer_country_code']??"0" }}-{{ (int)$report['Customer']['customer_contact']??"0" }}</li>

{{--                        <li>Start: {{  date('d-M-Y h:i:s A',strtotime($report['start_at']  ?? "N/A" ))  }}</li>--}}
{{--                        <li>END:  {{  date('d-M-Y h:i:s A',strtotime($report['end_at'] ?? "N/A" ))   }}</li>--}}
                    </ul>

                    <b class="cs-primary_color">Car Information:</b>
                    <ul style=" list-style-type: circle;">
                        <li>Plate# {{ $report['Car']['car_plate_number']  ?? "N/A" }}</li>
                        <li>Make:  {{$report['Car']['car_make'] ?? "N/A" }} </li>
                        <li>Model: {{$report['Car']['car_model'] ?? "N/A" }}</li>
                        <li>Year: {{$report['Car']['car_year'] ?? "N/A" }}</li>
                        <li>Vin: {{$report['Car']['car_vin_number'] ?? "N/A" }}</li>
                        <li>Mileage: {{$report['report_mileage'] ?? "N/A" }}</li>
                        <li>Interior: {{$report['report_interior'] ?? "N/A" }}</li>
                        <li>Exterior: {{$report['report_exterior'] ?? "N/A" }}</li>
                        <li>GCC: {{$report['report_gcc'] ?? "N/A" }}</li>

                    </ul>




                </li>


                    <li style="padding-right: 10%;">

                        <img class='body_type_image body_type_image_div'  src="{{asset('storage/qc_data_images/'.$report->qc_id.'/body_inspector_canvas.png')}}"
                             onerror="this.onerror=null;this.src='{{asset('storage/cars-body-type/'.$report['Car']['car_body_type'].'/image/image.png')}}';"
                        >

                        <div style="    display: flex; margin-top: -5%;
        justify-content: space-between;">
                            <span class="label info">P. Replaced القطعة مبدلة</span>
                            <span class="label success">Cos Paint صبغ تجميلي</span>
                            <span class="label danger">Filler معجون</span>
{{--                            <span class="label danger">Heavy Filler</span>--}}
                        </div>

                    </li>


            </ul>


            <?php

            //            dd($report);
            $list_counter = 1;

            $data_v1['interior'] = explode(',',$report->interior);
            $data_v1['exterior'] = explode(',',$report->exterior);
            $data_v1['mechanical_electrical'] = explode(',',$report->mechanical_electrical);
            $data_v1['test_drive'] = explode(',',$report->test_drive);
            $data_v1['additional_note'] = explode(',',$report->additional_note);

            $data_v1 = array_filter($data_v1);
            $data = json_decode($report['inspection_data']??[]);


            ?>

            @foreach($data as $key => $list)

                @if($key === 'car' || $key === "customer" || $list === null)
                    @continue
                @endif

                <?php

                    $set_key = explode('_', $key);
                    $set_key = end($set_key);
                    $set_key = str_replace('-',' ',$set_key);
                    $set_key = ucwords($set_key);
                    $temp_data[]  = $set_key.": ".$list;

                ?>

            @endforeach

            <?php

            if(!empty($temp_data))
            {

                // $data_v1['other'] = $temp_data;

            }

            ?>


            <div class="container">

                <div class="col-lg-12 row">
                    <?php



                    ?>



                @foreach($data_v1 as $key => $list)



                    @if(empty($list[0]))
                    @continue
                    @endif

                        <?php

                        $l_counter = 1;
                        $counter = 1;
                        $r_counter = 1;

                        $r_counter = round(count($list)/2);
                        $side_l = true;



                        ?>

                            <h5 class="col-lg-12">{{ucwords(str_replace('_',' ',$key))}}</h5>

                            @foreach($list as $item)

                            <?php


                                    if( $side_l === true)
                                    {

                                        $counter = $l_counter++;
                                        $side_l = false;
                                    }
                                    else
                                    {
                                        $counter = ++$r_counter;
                                        $side_l = true;
                                    }

                            ?>

                                    <div class="col-6">
                                       <p class="issues-p"  {!! strlen($item) > 11 ? 'style="line-height: 0.8"' : ""  !!}  >{{$counter}} {{$item}}</p>
                                    </div>
                             @endforeach



                @endforeach
                </div>



            </div>





            <div class="cs-note two_last_footer" >
                <div class="cs-note_right">
                    <b class="cs-primary_color" style="color: #000000" > {!! WebsiteData()['invoice_above_footer'] !!}  </b>

                </div>
            </div><!-- .cs-note -->


            <div class="cs-note"  style="    font-size: 13px;background-color: #030a6d; /*margin-top: 10px*/;justify-content:center">
                <div class="cs-note_right">
                    <b class="cs-primary_color" style="color: #eaeaea" > {!!  WebsiteData()['invoice_footer'] !!} </b>
                </div>
            </div><!-- .cs-note -->

        </div><!-- .cs-note -->

    </div>


</div>






</body>
</html>
