@extends('panel.layouts.app')

@push('head')

    <link rel="stylesheet" href="{{asset('template_assets')}}/vendor/select2/css/select2.min.css">
    <style>
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #2196F3;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>


@endpush

@section('body')



    <form method="post" id="user_edit_form" action="{{route('panel.profile.update')}}" enctype="multipart/form-data" autocomplete="off">
        @csrf

        <div class="modal-body">

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label>Full Name <span class="text-danger">*</span></label>
                    <input type="text" placeholder="Full Name" class="form-control" name="name" id="edit_user_name" required>
                </div>

                <div class="form-group col-md-6">
                    <label>Image</label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text">Upload</span>
                        </div>
                        <div class="custom-file" style="overflow: hidden">
                            <input type="file" class="custom-file-input" name="image">
                            <label class="custom-file-label">Choose file</label>
                        </div>
                    </div>

                </div>
            </div>

            <div class="form-row">

                <div class="form-group col-md-6" id="email_div">
                    <label>Email <span class="text-danger">*</span></label>
                    <input type="email" placeholder="Email" class="form-control" name="email" id="edit_user_email" onchange="GetUserNameByEmail()" required>
                </div>

                <div class="form-group col-md-6" id="edit-username_div">
                    <label>Username <span class="text-danger">*</span></label>
                    <input type="text" placeholder="Username" class="form-control" name="username" id="edit_user_username"  onchange="EditUsernameValidator()"  required>

                </div>



            </div>

            <div class="form-row">

                <div class="form-group col-md-6" id="edit-password_div">
                    <label>Password <span class="text-danger">*</span></label>
                    <input type="password" placeholder="Password" id="edit-password" class="form-control" name="password" onchange="OnPasswordConfirm()" >
                </div>

                <div class="form-group col-md-6">
                    <label>Confirm Password <span class="text-danger">*</span></label>
                    <input id="edit_confirm_password" type="password" placeholder="Confirm Password" class="form-control" name="confirm-password" onchange="OnPasswordConfirm()" >
                </div>

            </div>

            <div class="form-row">

                <div class="form-group col-md-6">
                    <label>Role <span class="text-danger">*</span></label>
                    <h3>{{ Auth::User()->getRoleNames()[0] ?? "N/A" }}</h3>
                </div>


                <div class="form-group col-md-6">
                    <label>Gender</label>
                    <select class="form-control default-select" name="gender" id="edit_user_gender" >

                        <option >Choose Gender</option>
                        <option value="male">Male</option>
                        <option value="female">Female</option>

                    </select>

                </div>

            </div>

            <div class="form-row">

                <div class="form-group col-md-4">
                    <label>Country </label>
                    <select class="form-control default-select" id="edit_country_data" onchange="GetCountryDail()" name="country">

                        <option selected="">Choose Country</option>
                        @foreach(GetCountryData() as $key => $list)
                            <option data-value="{{json_encode($list)}}" value="{{$list->FIFA}}">{{$list->official_name_en}}</option>
                        @endforeach

                    </select>

                </div>

                <div class="form-group col-md-3">
                    <label>Country Code</label>
                    <input type="number" placeholder="Country Code" id="edit_country_code" class="form-control" name="country_code">

                </div>

                <div class="form-group col-md-5" id="edit-contact_div">
                    <label>Mobile Number</label>
                    <input type="number" placeholder="Mobile Number" id="edit_user_contact" class="form-control" onchange="MobileNumberValidator()" name="contact">
                </div>

            </div>

            <div class="form-group">
                <label>Address</label>
                <input type="text" placeholder="Complete User Address" id="edit_user_address" class="form-control" name="address">
            </div>

        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
            <button type="submit" id="edit_user_form_submit"  class="btn btn-primary">Save changes</button>

        </div>
    </form>
    @push('scripts')

        <script>

            var SITEURL = "{{ url('/') }}";

            function OnPasswordConfirm()
            {

                try {

                    $('#edit-password-span').remove();

                } catch (e) {

                }

                if(document.getElementById('edit-password').value !== "" && document.getElementById('edit-password').value !== "")
                {
                    if( document.getElementById('edit-password').value === document.getElementById('edit_confirm_password').value)
                    {

                    }else
                    {
                        $('#edit-password-span').remove();
                        $('#edit-password_div').append('<span id="edit-password-span" class=" text-danger  fadeInUp">Password not same</span>');
                    }
                }



            }

            function GetCountryDail()
            {
                var user_data  = JSON.parse($('#edit_country_data option:checked').attr('data-value'));



                document.getElementById('edit_country_code').value = user_data.Dial;

            }

            function  GetUserNameByEmail()
            {

                var edit_user_email = document.getElementById('edit_user_email').value;

                EmailValidator(edit_user_email);



                try {

                    $('#edit-username-span').empty();

                } catch (e) {

                }

                var url = "/helper/username-generator/" + edit_user_email;
                console.log(url);
                $.ajax({



                    type: 'GET',
                    url:   SITEURL +  url,
                    success: function (data) {
                        console.log(data);
                        document.getElementById('edit_user_username').value = data;
                    }

                });


            }

            function EmailValidator(email)
            {
                try {

                    $('#email-span').empty();

                }catch (e) {

                }


                $.ajax({

                    type:'GET',
                    url:   SITEURL +  "/helper/email-validator/"+email+"/null",
                    success:function(data) {
                        if(data === "1")
                        {
                            $('#email_div').append('<span id="email-span" class=" text-danger  fadeInUp">email already taken</span>');
                        }
                        return data;
                    }

                });


                return "";


            }

            function EditUsernameValidator()
            {


                var edit_user_username = document.getElementById('edit_user_username').value;

                try {

                    $('#edit-username-span').empty();

                }catch (e) {

                }

                $.ajax({


                    type:'GET',
                    url:   SITEURL +  "/helper/username-validator/"+edit_user_username+'/null',
                    success:function(data) {


                        if(typeof data !== "string")
                        {

                            $('#edit-username_div').append('<span id="edit-username-span" class=" text-danger  fadeInUp">username already taken</span>');
                        }

                    }

                });




            }

            function MobileNumberValidator()
            {

                try {

                    $('#-edit-contact-span').empty();

                }catch (e) {

                }

                var code = document.getElementById('edit_country_code').value;
                var contact = document.getElementById('edit_user_contact').value;
                var url = "/helper/contact-validator/"+code+"/"+parseInt(contact)+"/null";

                console.log(url);

                $.ajax({


                    type:'GET',
                    url:   SITEURL +  url,
                    success:function(data) {

                        console.log(data);

                        if(typeof data !== "string" || data === "1" )
                        {

                            $('#edit-contact_div').append('<span id="-edit-contact-span" class=" text-danger  fadeInUp">Number already taken</span>');
                        }

                    }

                });



            }


            $( document ).ready(function() {
                let custom_form = document.getElementById("user_create_form");

                document.getElementById('edit_user_name').value = '{{Auth::User()->name}}';
                document.getElementById('edit_user_email').value = '{{Auth::User()->email}}';
                document.getElementById('edit_user_username').value = '{{Auth::User()->username}}';
                document.getElementById('edit_user_address').value = '{{Auth::User()->address}}';
                document.getElementById('edit_user_contact').value = '{{Auth::User()->contact}}';
                document.getElementById('edit_country_code').value = '{{Auth::User()->country_code}}';

                $('#edit_user_gender').val(''+'{{Auth::User()->gender}}'+'').trigger('change');


            });




        </script>

    @endpush


@endsection

@push('scripts')
    <script src="{{asset('template_assets')}}/vendor/select2/js/select2.full.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/select2-init.js"></script>

@endpush
