<button style="display:none" type="button"  id="view_user_button" class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target=".view_user_model">View Only</button>

<div class="modal fade view_user_model" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Show User</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>


                <div class="modal-body">

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label>Full Name <span class="text-danger">*</span></label>
                                <input readonly type="text" placeholder="Full Name" class="form-control" name="name" id="view_user_name" required>
                            </div>

                            <div class="form-group col-md-6">
                                <label>Image</label>
                            <div class="input-group mb-3">

                                    <img src="" width="100" height="100" id="view_user_image">

                            </div>

                            </div>
                        </div>

                        <div class="form-row">

                            <div class="form-group col-md-6" id="email_div">
                                <label>Email <span class="text-danger">*</span></label>
                                <input readonly type="email" placeholder="Email" class="form-control" name="email" id="view_user_email" onchange="GetUserNameByEmail()" required>
                            </div>

                            <div class="form-group col-md-6" id="edit-username_div">
                                <label>Username <span class="text-danger">*</span></label>
                                <input readonly type="text" placeholder="Username" class="form-control" name="username" id="view_user_username"  onchange="EditUsernameValidator()"  required>

                            </div>



                        </div>

                        <div class="form-row">

                                <div class="form-group col-md-6">
                                    <label>Role <span class="text-danger">*</span></label>
                                    {!! Form::select('roles[]', $roles,[], array('class' => 'form-control  default-select','multiple','required','id'=>'view_user_role')) !!}
                                </div>

                            <div class="form-group col-md-6">
                                <label>Gender</label>
                                <select class="form-control default-select" name="gender" id="view_user_gender" >

                                    <option >Choose Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>

                                </select>

                            </div>

                        </div>

                        <div class="form-row">

                            <div class="form-group col-md-3">
                                <label>Country Code</label>
                                <input readonly type="number" placeholder="Country Code" id="view_country_code" class="form-control" name="country_code">

                            </div>

                            <div class="form-group col-md-5" id="edit-contact_div">
                                <label>Mobile Number</label>
                                <input readonly type="number" placeholder="Mobile Number" id="view_user_contact" class="form-control" onchange="MobileNumberValidator()" name="contact">
                            </div>

                        </div>

                        <div class="form-group">
                            <label>Address</label>
                            <input readonly type="text" placeholder="Complete User Address" id="view_user_address" class="form-control" name="address">
                        </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>

                </div>

        </div>
    </div>
</div>

@push('scripts')

    <script>

        function OnViewUser(user_id)
        {

            $.ajax({

                url: "/panel/users/"+user_id+"/edit",
                type: "GET",
                success: function(data, textStatus, jqXHR){

                    // console.log(data.userRole);

               document.getElementById('view_user_name').value = data.user.name;
               document.getElementById('view_user_email').value = data.user.email;
               document.getElementById('view_user_username').value = data.user.username;
               document.getElementById('view_user_address').value = data.user.address;
               document.getElementById('view_user_contact').value = data.user.contact;
               document.getElementById('view_country_code').value = data.user.country_code;
               document.getElementById('view_user_image').src = "{{asset('storage')}}/users/"+data.user.id+"/"+data.user.image;
               Object.keys(data.userRole).forEach(key => {
                   $('#view_user_role').val(''+key+'').trigger('change');
                });
               $('#view_user_gender').val(''+data.user.gender+'').trigger('change');
               document.getElementById('user_view_form').setAttribute('action','/panel/users/'+user_id+'/updated');
               // document.getElementById('user_view_form').setAttribute('action','PATCH');
                    // /panel/users/4/updated

                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(jqXHR, textStatus, errorThrown);
                }
            })


            document.getElementById('view_user_button').click();

        }

    </script>

@endpush
