<button type="button" class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target=".bd-example-modal-lg">Create</button>

<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create New User</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>
            <form action="{{route('panel.users.store')}}" method="POST" enctype="multipart/form-data" id="user_create_form">

                @csrf

                <div class="modal-body">


                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label>Full Name <span class="text-danger">*</span></label>
                                <input type="text" placeholder="Full Name" class="form-control" name="name" required>
                            </div>

                            <div class="form-group col-md-6">
                                <label>Image</label>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">Upload</span>
                                </div>
                                <div class="custom-file" style="overflow: hidden">
                                    <input type="file" class="custom-file-input" name="image">
                                    <label class="custom-file-label">Choose file</label>
                                </div>
                            </div>

                            </div>
                        </div>

                        <div class="form-row">

                            <div class="form-group col-md-6" id="email_div">
                                <label>Email <span class="text-danger">*</span></label>
                                <input type="email" placeholder="Email" class="form-control" name="email" id="user_email" onchange="CreateGetUserNameByEmail()" required>
                            </div>

                            <div class="form-group col-md-6" id="username_div">
                                <label>Username <span class="text-danger">*</span></label>
                                <input type="text" placeholder="Username" class="form-control" name="username" id="user_username"  onchange="CreateUsernameValidator()"  required>

                            </div>



                        </div>

                        <div class="form-row">

                            <div class="form-group col-md-6" id="password_div">
                                <label>Password <span class="text-danger">*</span></label>
                                <input type="password" placeholder="Password" id="password" class="form-control" name="password" onchange="CreateOnPasswordConfirm()" required>
                            </div>

                            <div class="form-group col-md-6">
                                <label>Confirm Password <span class="text-danger">*</span></label>
                                <input id="confirm_password" type="password" placeholder="Confirm Password" class="form-control" name="confirm-password" onchange="CreateOnPasswordConfirm()" required>
                            </div>

                        </div>

                        <div class="form-row">

                                <div class="form-group col-md-6">
                                    <label>Role <span class="text-danger">*</span></label>
                                    {!! Form::select('roles[]', $roles,[], array('class' => 'form-control  default-select','required')) !!}
                                </div>

                            <div class="form-group col-md-6">
                                <label>Gender</label>
                                <select class="form-control default-select" name="gender" >

                                    <option >Choose Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>

                                </select>

                            </div>

                        </div>


                        <div class="form-row">

                            <div class="form-group col-md-4">
                                <label>Country </label>
                                <select class="form-control default-select" id="country_data" onchange="CreateGetCountryDail()" name="country">

                                    <option selected="">Choose Country</option>
                                    @foreach(GetCountryData() as $key => $list)
                                        <option data-value="{{json_encode($list)}}" value="{{$list->FIFA}}">{{$list->official_name_en}}</option>
                                    @endforeach

                                </select>

                            </div>

                            <div class="form-group col-md-3">
                                <label>Country Code</label>
                                <input type="number" placeholder="Country Code" id="country_code" class="form-control" name="country_code">

                            </div>

                            <div class="form-group col-md-5" id="contact_div">
                                <label>Mobile Number</label>
                                <input type="number" placeholder="Mobile Number" id="contact" class="form-control" onchange="CreateMobileNumberValidator()" name="contact">
                            </div>

                        </div>


                        <div class="form-group">
                            <label>Address</label>
                            <input type="text" placeholder="Complete User Address" class="form-control" name="address">
                        </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                    <button type="submit" hidden id="create_user_form_submit"  class="btn btn-primary">Save changes</button>
                    <button type="button" onclick="CreateUserForm()"  class="btn btn-primary">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>


@push('scripts')


    <script>
 var SITEURL = "{{ url('/') }}"; 
        function CreateOnPasswordConfirm()
        {

            console.log("OnPasswordConfirm");
            try {

                $('#password-span').remove();

            } catch (e) {

            }

            if(document.getElementById('password').value !== "" && document.getElementById('password').value !== "")
            {
                if( document.getElementById('password').value === document.getElementById('confirm_password').value)
                {

                }else
                {
                    $('#password-span').remove();
                    $('#password_div').append('<span id="password-span" class=" text-danger  fadeInUp">Password not same</span>');
                }
            }



        }

        function  CreateUserForm()
        {
            document.getElementById('create_user_form_submit').click();


        }

        function CreateGetCountryDail()
        {
            var user_data  = JSON.parse($('#country_data option:checked').attr('data-value'));

            document.getElementById('country_code').value = user_data.Dial;

        }

        function  CreateGetUserNameByEmail()
        {





            var user_email = document.getElementById('user_email').value;

            CreateEmailValidator(user_email);



            try {

                    $('#username-span').empty();

                } catch (e) {

                }


            $.ajax({


                    type: 'GET',
                    url:    SITEURL +  "/helper/username-generator/" + user_email,
                    success: function (data) {
                        document.getElementById('user_username').value = data;
                    }

                });


        }

        function CreateEmailValidator(email)
        {
            try {

                $('#email-span').empty();

            }catch (e) {

            }


            $.ajax({

                type:'GET',
                url:    SITEURL +  "/helper/email-validator/"+email+"/null",
                success:function(data) {
                    if(data === "1")
                    {
                        $('#email_div').append('<span id="email-span" class=" text-danger  fadeInUp">email already taken</span>');
                    }
                  return data;
                }

            });


            return "";


        }

        function CreateUsernameValidator()
        {


            var user_username = document.getElementById('user_username').value;

            try {

                $('#username-span').empty();

            }catch (e) {

            }

            $.ajax({


                type:'GET',
                url:   SITEURL +  "/helper/username-validator/"+user_username+'/null',
                success:function(data) {


                    if(typeof data !== "string")
                    {

                        $('#username_div').append('<span id="username-span" class=" text-danger  fadeInUp">username already taken</span>');
                    }

                }

            });




        }

        function CreateMobileNumberValidator()
        {

            try {

                $('#contact-span').empty();

            }catch (e) {

            }

            var code = document.getElementById('country_code').value;
            var contact = document.getElementById('contact').value;
            var url = "/helper/contact-validator/"+code+"/"+contact+"/null";


            $.ajax({


                type:'GET',
                url:    SITEURL +  url,
                success:function(data) {

                    if(typeof data !== "string" || data === "1" )
                    {

                        $('#contact_div').append('<span id="contact-span" class=" text-danger  fadeInUp">Number already taken</span>');
                    }

                }

            });



        }

    </script>

@endpush
