@extends('panel.layouts.app')

@push('head')

    <!-- Datatable -->
    <link href="{{asset('template_assets')}}/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

@endpush

@section('body')


    <div class="row">



        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    @can('user-create')
                    @include('panel.users.model.create')
                    @endcan

                    @can('user-edit')
                    @include('panel.users.model.edit')
                    @endcan


                    @include('panel.users.model.view')

                    @can('user-delete')
                    @include('panel.users.model.destroy')
                    @endcan

                    <div class="table-responsive">
                        <table id="example3" class="display min-w850">
                            <thead>
                            <tr>
                                <th></th>
                                <th>Name</th>
                                <th>Username</th>
                                <th>Email</th>
                                <th>Role</th>
                                <th>Mobile</th>
                                <th>Joining Date</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($data as $key => $user)

                                <?php

                                $user_image = asset('template_assets')."/images/profile/small/pic1.jpg";
                                $destinationPath = 'users/'.$user->id.'/'.$user->image;


                                if(Storage::exists("public/".$destinationPath))
                                {
                                    $user_image = asset('storage/'.$destinationPath);
                                }

                                ?>

                                <tr>

                                <td><img class="rounded-circle" width="35" src="{{$user_image}}" alt=""></td>
                                <td>{{$user->name}}</td>
                                <td>{{$user->username}}</td>
                                <td>{{$user->email}}</td>
                                <td>
                                    <a href="javascript:void(0);"><strong class="text-black">

                                            @if(!empty($user->getRoleNames()))
                                                @foreach($user->getRoleNames() as $v)
                                                    <label class="badge badge-success">{{ $v }}</label>
                                                @endforeach
                                            @endif

                                        </strong></a>
                                </td>
                                <td>
                                    <a href="javascript:void(0);"><strong class="text-black">


                                    {{ ($user->country_code && $user->contact) ? "+".$user->country_code.$user->contact : "Not Set"  }}

                                        </strong></a></td>
                                <td>
                                    {{$user->created_at->diffForHumans()}}
                                    <br>
                                    {{$user->created_at}}
                                </td>
                                <td>
                                    <div class="d-flex">

                                        <div class="col">
                                            <a title="Show User" href="#"  onclick="OnViewUser('{{$user->id}}')" class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-eye"></i></a>
                                        </div>

                                        @can('user-edit')
                                        <div class="col">
                                            <a title="Edit User" href="#" onclick="OnEditUser('{{$user->id}}')" class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-pencil"></i></a>
                                        </div>
                                        @endcan


                                        @can('user-delete')
                                        <div class="col">
                                            <a title="Remove User" href="#" onclick="OnDeleteModel('{{$user->id}}','{{$user->name}}')" class="btn btn-danger shadow btn-xs sharp"><i class="fa fa-trash"></i></a>
                                        </div>
                                        @endcan

                                    </div>
                                </td>
                            </tr>

                            @endforeach

                           </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

    </div>

@endsection


@push('scripts')

    <!-- Datatable -->
    <script src="{{asset('template_assets')}}/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/datatables.init.js"></script>


    <script>

        @can('user-delete')
        function OnDeleteModel(user_id,user_name) {

            document.getElementById('delete-user-model-title').innerText = "About to Delete user \""+user_name+"\"";
            document.getElementById('destroy_user_form').setAttribute('action','/panel/users/'+user_id+'/deleted')

            document.getElementById('user-delete-button').click();
        }
        @endcan




    </script>

@endpush
