@extends('panel.layouts.app')

@push('head')

    <link rel="stylesheet" href="{{asset('template_assets')}}/vendor/select2/css/select2.min.css">
    <style>
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #2196F3;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(26px);
            -ms-transform: translateX(26px);
            transform: translateX(26px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 34px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>

    <script src="{{asset('tinymce/tinymce.min.js')}}"></script>

    <style>


    </style>

@endpush

@section('body')



    <div class="row">

        <div class="col-lg-12">
            <div class="card">
                <div class="row">

                    <div class="card-header border-0 pb-0" style="width: 100%;">

                        <div class="pull-left">
                            <h2>Website Setup</h2>
                        </div>


                    </div>


                </div>

                <div class="card-body">

                    @if ($message = Session::get('success'))
                        <div class="alert alert-success">
                            <p>{{ $message }}</p>
                        </div>
                    @endif


                    <form action="{{route('panel.setup.update')}}" method="post" enctype="multipart/form-data">

                        <fieldset   @can('setup-manage')  @else disabled  @endcan  >

                        @csrf

                        <div class="col-lg-12 row">


                            <div class="form-group col-md-6" >
                                <label>Title</label>
                                <input type="text" maxlength="12" class="form-control" name="title" value="{{$setup->title}}" >
                            </div>

                            <div class="form-group col-md-6" >
                                <label>QR Code URL</label>
                                <input type="text" maxlength="191" class="form-control" name="qr_code_url" value="{{$setup->qr_code_url}}" required>
                            </div>


                            <div class="form-group col-md-6" >
                                <label>Memo</label>
                                <input type="text" maxlength="23" class="form-control" name="memo" value="{{$setup->memo}}" >
                            </div>

                            <div class="form-group col-md-6" >
                                <label>Telephone</label>
                                <input type="text"  maxlength="15" class="form-control" name="tel"  value="{{$setup->tel}}">
                            </div>

                            <div class="form-group col-md-6" >
                                <label>Mobile</label>
                                <input type="text" maxlength="15"  class="form-control" name="mob" value="{{$setup->mob}}" >
                            </div>

                            <div class="form-group col-md-6" >
                                <label>Full Logo</label>
                                <input type="file"   class="form-control" name="full_logo" >
                            </div>

                            <div class="form-group col-md-6" >
                                <label>Small Logo</label>
                                <input type="file"   class="form-control" name="short_logo" >
                            </div>

                            <div class="form-group col-md-6" >
                                <label>Watermark</label>
                                <input type="file"   class="form-control" name="watermark" >
                            </div>




                            <div class="form-group col-md-6" >
                                <label>Report VIA SMS Auto</label>
                                <br>
                                <label class="switch">
                                    <input type="checkbox" class="form-control" name="auto_sms" onchange="SwitchToggle(this.id)" id="auto_sms"
                                        {!!  $setup->auto_sms === "1" ? " value='1' checked" : ""  !!} >

                                    <span class="slider round"></span>
                                </label>

                            </div>


                                <div class="form-group col-md-6">
                                    <label>Set Countries</label>
                                    <br>

                                    <select class="set_countries" name="set_countries[]" multiple="multiple">

                                        @forelse(GetAllCountryData() as $key => $list)


                                                <option {{$list->status===1?"selected":""}} data-value="{{json_encode($list)}}" value="{{$list->FIFA}}">{{$list->official_name_en}}</option>

                                        @empty

                                        @endforelse

                                    </select>

                                </div>




                            <div class="form-group col-md-12" >
                                <label>Invoice Above Footer</label>
                                <textarea class="form-control" id="invoice_above_footer" name="invoice_above_footer" style="height: 200px">{{$setup->invoice_above_footer ?? ""}}</textarea>
                            </div>

                            <div class="form-group col-md-12" >
                                <label>Invoice Footer</label>
                                <textarea class="form-control" id="invoice_footer"  name="invoice_footer" style="height: 200px">{{$setup->invoice_footer ?? ""}}</textarea>
                            </div>




                        </div>


                        <div class="form-group col-md-6"  style="margin-top: 20px">

                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>



                        </fieldset>




                    </form>



                </div>

            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script src="{{asset('template_assets')}}/vendor/select2/js/select2.full.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/select2-init.js"></script>
    <script>



        // multi select box
        $('.set_countries').select2();

        function SwitchToggle(id)
        {

            if(document.getElementById(id).value === "1")
            {
                document.getElementById(id).value = "";
            }else
            {
                document.getElementById(id).value = "1";
            }

        }

    </script>

    <script>


        // Full featured TinyMCE editor
        tinymce.init({
            selector: '#invoice_footer',
            plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
            //editimage_cors_hosts: ['picsum.photos'],
            menubar: 'file edit view insert format tools table help',
            toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
            toolbar_sticky: true,
            //toolbar_sticky_offset: isSmallScreen ? 102 : 108,
            autosave_ask_before_unload: true,
            autosave_interval: '30s',
            autosave_prefix: '{path}{query}-{id}-',
            autosave_restore_when_empty: false,
            autosave_retention: '2m',
            image_advtab: true,
            link_list: [
                { title: 'My page 1', value: 'https://www.codexworld.com' },
                { title: 'My page 2', value: 'http://www.codexqa.com' }
            ],
            image_list: [
                { title: 'My page 1', value: 'https://www.codexworld.com' },
                { title: 'My page 2', value: 'http://www.codexqa.com' }
            ],
            image_class_list: [
                { title: 'None', value: '' },
                { title: 'Some class', value: 'class-name' }
            ],
            importcss_append: true,
            file_picker_callback: (callback, value, meta) => {
                /* Provide file and text for the link dialog */
                if (meta.filetype === 'file') {
                    callback('https://www.google.com/logos/google.jpg', { text: 'My text' });
                }

                /* Provide image and alt text for the image dialog */
                if (meta.filetype === 'image') {
                    callback('https://www.google.com/logos/google.jpg', { alt: 'My alt text' });
                }

                /* Provide alternative source and posted for the media dialog */
                if (meta.filetype === 'media') {
                    callback('movie.mp4', { source2: 'alt.ogg', poster: 'https://www.google.com/logos/google.jpg' });
                }
            },
            templates: [
                { title: 'New Table', description: 'creates a new table', content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>' },
                { title: 'Starting my story', description: 'A cure for writers block', content: 'Once upon a time...' },
                { title: 'New list with dates', description: 'New List with dates', content: '<div class="mceTmpl"><span class="cdate">cdate</span><br><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>' }
            ],
            template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
            template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
            height: 400,
            image_caption: true,
            quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
            noneditable_class: 'mceNonEditable',
            toolbar_mode: 'sliding',
            contextmenu: 'link image table',
            //skin: useDarkMode ? 'oxide-dark' : 'oxide',
            //content_css: useDarkMode ? 'dark' : 'default',
            content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }'
        });
        tinymce.init({
            selector: '#invoice_above_footer',
            plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
            //editimage_cors_hosts: ['picsum.photos'],
            menubar: 'file edit view insert format tools table help',
            toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
            toolbar_sticky: true,
            //toolbar_sticky_offset: isSmallScreen ? 102 : 108,
            autosave_ask_before_unload: true,
            autosave_interval: '30s',
            autosave_prefix: '{path}{query}-{id}-',
            autosave_restore_when_empty: false,
            autosave_retention: '2m',
            image_advtab: true,
            link_list: [
                { title: 'My page 1', value: 'https://www.codexworld.com' },
                { title: 'My page 2', value: 'http://www.codexqa.com' }
            ],
            image_list: [
                { title: 'My page 1', value: 'https://www.codexworld.com' },
                { title: 'My page 2', value: 'http://www.codexqa.com' }
            ],
            image_class_list: [
                { title: 'None', value: '' },
                { title: 'Some class', value: 'class-name' }
            ],
            importcss_append: true,
            file_picker_callback: (callback, value, meta) => {
                /* Provide file and text for the link dialog */
                if (meta.filetype === 'file') {
                    callback('https://www.google.com/logos/google.jpg', { text: 'My text' });
                }

                /* Provide image and alt text for the image dialog */
                if (meta.filetype === 'image') {
                    callback('https://www.google.com/logos/google.jpg', { alt: 'My alt text' });
                }

                /* Provide alternative source and posted for the media dialog */
                if (meta.filetype === 'media') {
                    callback('movie.mp4', { source2: 'alt.ogg', poster: 'https://www.google.com/logos/google.jpg' });
                }
            },
            templates: [
                { title: 'New Table', description: 'creates a new table', content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>' },
                { title: 'Starting my story', description: 'A cure for writers block', content: 'Once upon a time...' },
                { title: 'New list with dates', description: 'New List with dates', content: '<div class="mceTmpl"><span class="cdate">cdate</span><br><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>' }
            ],
            template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
            template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
            height: 400,
            image_caption: true,
            quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
            noneditable_class: 'mceNonEditable',
            toolbar_mode: 'sliding',
            contextmenu: 'link image table',
            //skin: useDarkMode ? 'oxide-dark' : 'oxide',
            //content_css: useDarkMode ? 'dark' : 'default',
            content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }'
        });



    </script>


@endpush
