@extends('panel.layouts.app')


@section('body')

    @include('panel.roles.model.delete')

    <div class="row">

        <div class="col-lg-12">
            <div class="card">
                    <div class="row">

                        <div class="card-header border-0 pb-0" style="width: 100%;">

                            <div class="pull-left">
                                <h2>Role Management</h2>
                            </div>
                            <div class="">
                                @can('role-create')
                                    <a class="btn btn-success" href="{{ route('panel.roles.create') }}"> Create New Role</a>
                                @endcan
                            </div>

                        </div>


                    </div>

                    <div class="card-body">

                        @if ($message = Session::get('success'))
                            <div class="alert alert-success">
                                <p>{{ $message }}</p>
                            </div>
                        @endif


                        <table class="table table-bordered">
                            <tr>
                                <th>No</th>
                                <th>Name</th>
                                <th width="280px">Action</th>
                            </tr>
                            @foreach ($roles as $key => $role)
                                @if($role->name === "Admin")
                                    @continue
                                @endcan
                                <tr >
                                    <td>{{ ++$i }}</td>
                                    <td>{{ $role->name }}</td>
                                    <td style="display: flex; justify-content: space-between;">
                                        <a class="btn btn-info" href="{{ route('panel.roles.show',$role->id) }}">Show</a>
                                        @can('role-edit')
                                            <a class="btn btn-primary" href="{{ route('panel.roles.edit',$role->id) }}">Edit</a>
                                        @endcan
                                        @can('role-delete')
                                            {!! Form::open(['method' => 'DELETE','route' => ['panel.roles.destroy', $role->id],'style'=>'display:inline']) !!}
                                            <button type="button" class="btn btn-danger" id="delete_role_{{$role->id}}" onclick="DeleteRole(this.id,'{{$role->name}}')">Delete</button>
                                            <button type="submit"  id="delete_role_{{$role->id}}_submit" class="btn btn-danger" hidden >Delete</button>
                                            {!! Form::close() !!}
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </table>


                        {!! $roles->render() !!}
                    </div>

            </div>
        </div>
    </div>
@endsection

@push('scripts')



@endpush
