@extends('panel.layouts.app')

@section('body')
    <div class="row">
        <div class="col-lg-12 margin-tb">
            <div class="pull-left">
                <h2>Edit Role</h2>
            </div>
            <div class="pull-right">
                <a class="btn btn-primary" href="{{ route('panel.roles.index') }}"> Back</a>
            </div>
        </div>
    </div>


    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.<br><br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif


    {!! Form::model($role, ['method' => 'PATCH','route' => ['panel.roles.update', $role->id]]) !!}

    <div class="container-fluid">
        <div class="row" style="margin-left: 60px; ">

            @foreach($permission as $list)
                @php($temp_title[] = [])
                @if(!in_array($list->title,$temp_title))
                    @php($temp_title[] = $list->title)
                @else
                    @continue
                @endif

                <div class="card " style="width: 18rem; margin-top: 10px; padding-left: 30px;">
                    <div class="card-body " style="padding-left: 30px;">
                        <h5 class="card-title">{{str_replace('Clipboard','Whiteboard',ucwords(str_replace('-',' ',$list->title))) }}</h5>
                        @foreach($permission as $value)
                            @if($list->title === $value->title)
                                <label style="display: block;">{{ Form::checkbox('permission[]', $value->id, in_array($value->id, $rolePermissions) ? true : false, array('class' => 'name')) }}
                                    {{  ucwords(str_replace('-',' ',$value->name)) }}</label>
                            @endif
                        @endforeach
                    </div>
                </div>&nbsp;&nbsp;

            @endforeach

                <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
        </div>
    </div>


    {!! Form::close() !!}


@endsection

