@extends('panel.layouts.app')

@push("head")

    <link rel="stylesheet" href="{{asset('css/custom_css_defined.css')}}">

    <!-- Datatable -->
    <link href="{{asset('template_assets')}}/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

@endpush


@section('title',$pageTitle)

@section('body')

    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"> All Inspections </h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="example3" class="table table-bordered table-striped verticle-middle table-responsive-sm">
                        <thead>


                        <tr>
                            <td scope="col">#</td>
                            <th >Package</th>
                            <th >Customer</th>
                            <th >Car</th>
                            <th >Start at</th>
                            <th >End At</th>
                            <th >Action</th>
                        </tr>


                        </thead>
                        <tbody>

                        @php($counter = 1)

                        @foreach($quick_checks as $list)

                            <tr class="alert alert-dismissible">

                                <td>{{$counter}}</td>
                                <td>{{$list->package_name}}</td>
                                <td>
                                    {{$list->customer_name}} /  {{$list->customer_country_code}}-{{$list->customer_contact}}
                                </td>
                                <td>
{{--                                    <span class="badge badge-warning"> {{$list->car_name}}</span>--}}
                                    <span class="badge badge-warning"> {{$list->car_make}}</span>
                                    <span class="badge badge-warning"> {{$list->car_plate_number}}</span>

                                </td>

                                <td>
                                    {{$list->start_at}}
                                    <br>
                                    {{ \Carbon\Carbon::parse($list->start_at)->diffForhumans() }}

                                </td>

                                <td>
                                    @if(!empty($list->end_at))

                                    {{$list->end_at}}
                                    <br>
                                    Took {{ \Carbon\Carbon::parse($list->end_at)->diffInMinutes(\Carbon\Carbon::parse($list->start_at)) }} Minutes

                                    @else
                                        <label class="badge badge-info">  In Progress </label>

                                    @endif

                                </td>

                                <td>

                                    @can('inspection-log')
                                    <a title="Inspection Logs"  class="mr-4"  target="_blank" href="{{route('panel.quick-check.inspection.logs',$list->qc_id)}}" >
                                        <i class="fa fa-sticky-note-o ak-action-anchor"></i>
                                    </a>
                                    @endcan


                                    @can('inspection-sms-sent')
                                    <a  title="Send SMS" class="mr-4" onclick="SendSms('{{$list->qc_id}}')" >
                                        <i class="fa fa-mail-forward ak-action-anchor"></i>
                                    </a>
                                    @endcan



                                   @can('inspection-report')
                                       @if($list->customer_name !== null && $list->car_make !== null )
                                    <a title="Show Inspection Report" target="_blank" class="mr-4" href="{{route('report.get-by-id',$list->qc_id)}}"  >
                                        <i class="fa fa-flag color-danger ak-action-anchor"></i>
                                    </a>
                                       @endif
                                   @endcan



                                    @can('inspection-continue')
                                    @if(\Carbon\Carbon::parse($list->start_at)->diffInHours(now()) < 4)
                                        <a title="Continue Inspection" href="{{route('panel.quick-check.inprogress',$list->qc_id)}}" class="mr-4">
                                            <i class="fa fa-play-circle color-muted ak-action-anchor "></i>
                                        </a>
                                    @endif
                                    @endcan


                                   @can('inspection-remove')
                                    <a title="Remove Inspection Data" class="mr-4" href="javascript:void(0);" onclick="DeleteInspectionModel('{{$list->qc_id}}','{{$counter++}}')" >
                                        <i class="fa fa-close color-danger ak-action-anchor"></i>
                                    </a>
                                   @endcan




                                </td>
                            </tr>


                        @endforeach



                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    @can('inspection-remove')

    @include('panel.quick_check.model.delete')

    @endcan


@endsection


@push('scripts')

    <!-- Datatable -->
    <script src="{{asset('template_assets')}}/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/datatables.init.js"></script>

    @can('inspection-remove')
    <script>

        function DeleteInspectionModel(qc_id,id)
        {
               DeleteInspectionSetup(qc_id,id)
               document.getElementById('inspection-delete-button').click();

        }

    </script>
    @endcan

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>

        function ShowLoading()
        {
            Swal.fire('Processing your request, please wait...')
            Swal.showLoading()
        }

    </script>

    @can('inspection-sms-sent')
    <script>

var SITEURL = "{{ url('/') }}";

        function SendSms(id){


            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: 'SMS has been sent successfully',
                showConfirmButton: false,
                timer: 1500
            })

            $.ajax({

                url:   SITEURL +  "/panel/sms-sender/"+id,
                type: "GET",
                success: function(data, textStatus, jqXHR){


                }

            });
        }

    </script>
    @endcan

@endpush
