@extends('panel.layouts.app')

@push("head")

    <link rel="stylesheet" href="{{asset('css/custom_css_defined.css')}}">

    <!-- Datatable -->
    <link href="{{asset('template_assets')}}/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('template_assets')}}/vendor/select2/css/select2.min.css">
    <link href="{{asset('template_assets')}}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

    @section('title', $pageTitle);

    <style>

        .card{
            margin: 20px;

        }

        @media screen and (max-width: 700px) {
            .timeline-panel{
                flex-direction: column !important;
            }
            .ite-cards{
                padding: 10px 0px !important;
            }
            .ite-col{
                margin: 0px !important;
            }
            .card {
                 margin: 10px 0px !important;
            }
            .ite-col-2{
                margin: 0px !important;
            }
            .custom-control{
                width: 100% !important;
                padding-left: 0px !important;
            }
        }



        #bordered_collapseFour-div{
            height: 800px;
        }

    </style>

@endpush



@section('body')


    <div class="col-lg-12">

        <div class="card">
            <div class="card-header d-block">
                <h4 class="card-title">Quick Check Start</h4>
                <p class="m-0 subtitle">Please Follow the flow of work  <code> Package Selection </code> > <code> Customer Selection </code>   >  <code>Car and Body Type Selection </code>
                    > <code> Start Inspection </code> > <code> Finish </code>
                </p>


            </div>

            <div class="card-body ">

                <div id="accordion-two" class="accordion accordion-danger-solid">


                    <form method="GET" id="quick_check_form">

                        @csrf

                        <div class="col-lg-6 row" style="margin-bottom: 2%">

                            <div class="col-lg-6">

                                <select id="package-select" name="package" class="package_selection" onchange="GetHeadChecks()" >

                                    <option  value  >  Select Package </option>
                                    @forelse( GetPackages() as $list )

                                        <option  value="{{$list['package_id']}}" >  {{$list['package_name']}} </option>

                                    @empty

                                    @endforelse

                                </select>

                            </div>

                        </div>

{{--                    package selection--}}
                    <div hidden class="accordion__item">
                        <div class="accordion__header collapsed" data-toggle="collapse" data-target="#bordered_collapseOne"> <span class="accordion__header--text"> <i class="fa fa-money"></i> Package </span>
                            <span class="accordion__header--indicator"></span>
                        </div>
                        <div id="bordered_collapseOne" class="collapse accordion__body" data-parent="#accordion-two">
                            <div class="accordion__body--text">

                                <div class="row">



                                </div>

                            </div>
                        </div>
                    </div>

{{--                    customer selection--}}
                    <div class="accordion__item">
                        <div class="accordion__header collapsed" data-toggle="collapse" data-target="#bordered_collapseTwo"> <span class="accordion__header--text"> <i class=" fa fa-user "> </i>  Customer </span>
                            <span class="accordion__header--indicator"></span>
                        </div>
                        <div id="bordered_collapseTwo" class="collapse accordion__body" data-parent="#accordion-two">
                            <div class="accordion__body--text">

                                <div class="row">

                                    <div class="col-lg-6 ak-vertical-line">

                                        <select id="customer-select" name="customer" class="package_selection">

                                            <option  value  >  Select Customer </option>
                                            @forelse( GetCustomers() as $list )

                                                <option  value=" {{$list['customer_id']}}" >  {{$list['customer_name']}} / +{{$list['customer_country_code']}}{{$list['customer_contact']}} </option>

                                            @empty

                                            @endforelse

                                        </select>

                                    </div>

                                    @can('customer-create')
                                    <div class="col-lg-6">
                                        <button class="btn btn-primary" type="button"  onclick="document.getElementById('create_customer_model_button').click()"  style="float: right; margin-top: 10px"> Create New </button>
                                    </div>
                                    @endcan


                                </div>



                            </div>
                        </div>
                    </div>

{{--                    car selection--}}
                    <div class="accordion__item">
                        <div class="accordion__header collapsed" data-toggle="collapse" data-target="#bordered_collapseThree"> <span class="accordion__header--text"> <i class="fa fa-car"></i> Car and Body Type </span>
                            <span class="accordion__header--indicator"></span>
                        </div>
                        <div id="bordered_collapseThree" class="collapse accordion__body" data-parent="#accordion-two">
                            <div class="accordion__body--text">


                                <div class="row">

                                    <div class="col-lg-6 ak-vertical-line">

                                        <select id="car-select" name="car" class="package_selection">

                                            <option  value  >  Select Car </option>
                                            @forelse( GetCars() as $list )

                                                <option  value="{{$list->car_id}}"> {{$list->car_name}} / {{$list->car_make}} / {{$list->car_plate_number}} / {{$list->car_model}} /  {{ $list->car_body_type != null ? App\Models\CarBodyType::find( $list->car_body_type )->cby_name : "Body Type Not Selected" }}    </option>


                                            @empty

                                            @endforelse

                                        </select>

                                    </div>

                                    @can('car-create')
                                    <div class="col-lg-6">
                                        <button class="btn btn-primary" type="button"   onclick="document.getElementById('create_car_model_button').click()"  style="float: right; margin-top: 10px"> Create New </button>
                                    </div>
                                    @endcan


                                </div>



                            </div>
                        </div>

                        <button id="inspection_start_button" onclick="StartStarted()" class="btn btn-primary"  style="margin-top: 2%"> Start </button>

                    </div>




{{--                    Start Inspection--}}
                    <div class="accordion__item">

                        <div class="accordion__header collapsed" data-toggle="collapse" data-target="#bordered_collapseFive"> <span class="accordion__header--text"><i class="fa fa-tasks "></i> Start Inspection </span>
                            <span class="accordion__header--indicator"></span>
                        </div>
                        <div id="bordered_collapseFive" class="collapse accordion__body" data-parent="#accordion-two">
                            <div class="accordion__body--text">

                                <div class="row col-lg-12 ite-col-2" id="start-inspection">





                                </div>




                            </div>
                        </div>
                    </div>



                    </form>


                </div>
            </div>
        </div>
    </div>


    @include('panel.customers.model.create_model')
    @include('panel.cars.model.create')


@endsection

@push('scripts')

    <!-- Datatable -->
    <script src="{{asset('template_assets')}}/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/datatables.init.js"></script>
    <script src="{{asset('template_assets')}}/vendor/select2/js/select2.full.min.js"></script>



    <script>

        $("#create_car_model_button").hide();
        $("#create_customer_model_button").hide();


        $("#inspection_start_button").hide();

        // single select box
        $("#package-select").select2();

        $("#customer-select").select2();

        $("#car-select").select2();

        var SITEURL = "{{ url('/') }}";

        function GetHeadChecks()
        {
            $('#start-inspection').empty();
            $("#inspection_start_button").hide();



            $.ajax({
                type: "GET",
                url:  SITEURL + "/helper/get-head-check-data-by-package-id/"+$("#package-select").val(),
                success: function(data, textStatus, jqXHR){
                      SetupInspection(data)
                },
                error: function(jqXHR, textStatus, errorThrown){}
            })

        }


        function SetupInspection(data)
        {
            if(data.length !== 0)
            {
                $("#inspection_start_button").show();
            }


            var interior = '<label>Interior</label><textarea name="interior" id="interior"  class="form-control" placeholder="Interior Notes, please use comma for separations"></textarea>';
            var exterior = '<label>Exterior</label><textarea name="exterior" id="exterior"  class="form-control" placeholder="Exterior Notes, please use comma for separations"></textarea>';
            var mechanical_electrical = '<label>Mechanical Electrical</label><textarea name="mechanical_electrical" id="mechanical_electrical"  class="form-control" placeholder="Mechanical Notes, please use comma for separations"></textarea>';
            var test_drive = '<label>Test Drive</label><textarea name="test_drive" id="test_drive"  class="form-control" placeholder="Test Drive Notes, please use comma for separations"></textarea>';
            $('#start-inspection').append(interior);
            $('#start-inspection').append(exterior);
            $('#start-inspection').append(mechanical_electrical);
            $('#start-inspection').append(test_drive);




            var additional = '<label>Additional Notes</label><textarea name="additional_note" id="additional_note"  class="form-control" placeholder="Additional Notes, please use comma for separations"></textarea>';
            $('#start-inspection').append(additional);


            var html1 = "";
            var html2 = "";
            var html3 = "";

            for(var i = 0; i < data.length; i++)
            {
                var html2 = "";
                var html3 = "";

                html1 = '<div  class=" card custom-card col-lg-5 ite-col">'+
                    '<div class="card-header">'+
                    '<h4 class="card-title">'+data[i].head_name+'</h4>'+
                    '</div>'+
                    '<div class="card-body ite-cards">'+
                    '<div  class="widget-media">'+
                    '<ul class="timeline">';

                try{

                    for (var j = 0 ; j <  data[i].check_list.length ; j++)
                    {

                        var temp_name = data[i].check_list[j].check_id+'_'+data[i].check_list[j].check_name.split(' ').join('-');

                        var  html2_1 ='<li>'+
                            '<div class="timeline-panel">'+
                            '<div class="media-body">'+
                            '<h5 class="mb-0 ">'+data[i].check_list[j].check_name+'</h5>'+
                            '<br>'+
                            '</div>'+
                            '<div class="custom-control" style="z-index: auto;">'+
                            '<select class="form-control default-select" id="'+temp_name+'" name="'+temp_name+'">'+
                            '<option value> Select Option </option>';

                        var html2_2 = "";

                        for(var k = 0 ; k < data[i].check_list[j].check_option.length ; k++)
                        {
                            html2_2 += '<option value="'+data[i].check_list[j].check_option[k]+'">   '+data[i].check_list[j].check_option[k]+' </option>';
                        }

                        /*'<option value="0"> Check </option>'+
                        '<option value="1"> Not Check </option>'+*/


                        var  html2_3 = '</select>'+
                            '</div>'+
                            '</div>'+
                            '</li>';

                        html2 += html2_1+html2_2+html2_3;

                    }
                }catch (e) {

                }




                html3 =    '</ul>'+
                    '</div>'+
                    '</div>'+
                    '</div>';

                $('#start-inspection').append(html1+html2+html3);


            }

        }

        function  StartStarted()
        {


            var queryString = $('#quick_check_form').serializeArray();
            console.log(queryString);

            ShowLoading();
            $.ajax({
                type: "POST",
                url: "{{route('panel.quick-check.created')}}",
                data: queryString,
                success: function(data, textStatus, jqXHR){


                    window.location.replace( SITEURL + "/panel/quick-check/in-progress/"+data.qc_id);

                    },
                error: function(jqXHR, textStatus, errorThrown){

                }
            })



        }

    </script>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>

        function ShowLoading()
        {
            Swal.fire('Processing your request, please wait...')
            Swal.showLoading()
        }

    </script>



@endpush
