<button hidden id="view_package_button" type="button" class="btn btn-primary mb-2" data-toggle="modal" data-target=".view-package">View Package</button>

<div class="modal fade view-package" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="view_package_title"></h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>
            <div class="modal-body" id="view_package_body">

            <table class="table responsive">

                <tr>
                <th>#</th>
                <th>Key</th>
                <th>Value</th>
                </tr>

                <tbody id="view_tbody">

                </tbody>

            </table>


            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

@push('scripts')

    <script>

        function SetViewPackage(data)
        {
            $('#edit-package-body').empty();

            var d = new Date(data.package.created_at);
            var date = d.getUTCFullYear()+"-"+d.getUTCMonth()+'-'+d.getUTCDate()+' '+d.getUTCHours()+':'+d.getUTCMinutes();
            document.getElementById('view_package_title').innerText = data.package.package_name+" created at "+date;

            var data = JSON.parse(data.package.package_data);

            if(typeof data === "object")
            {
                $('#view_tbody').empty();

                var data_html = "";

                for(var i = 0 ; i < data.length ; i++)
                {
                    for (let k in data[i]) {

                        var j = i;
                        data_html = '<tr>'+
                            '<td>'+j+++'</td>'+
                            '<td>'+k+'</td>'+
                            '<td>'+data[i][k]+'</td>'+
                            '</tr>';
                    }


                    $('#view_tbody').append(data_html);
                }

            }

            document.getElementById('view_package_button').click();
        }


    </script>

@endpush
