@push('head')

    <link rel="stylesheet" href="{{asset('template_assets')}}/vendor/select2/css/select2.min.css">

@endpush

<button type="button" hidden id="edit_package_button"  class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target=".edit-package-model">Edit</button>

<div class="modal fade edit-package-model" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="edit_package_title" ></h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>
            <form  method="POST"  id="package_edit_form">

                @csrf

                <div class="modal-body"  >


                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Package Name <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Full Package Name" class="form-control" name="package_name" id="edit_package_name" required>
                        </div>
                    </div>

                    <div class="form-row">

                        <div class="form-group col-lg-12">
                            <label>Assign Head to Package</label>

                            <select class="edit_multi_heads" name="heads[]" multiple="multiple">

                                @forelse(GetHeads() as $list)
                                    <option value="{{$list['head_id']}}"> {{$list['head_name']}}   </option>
                                @empty

                                @endforelse

                            </select>

                        </div>


                    </div>


                    <div class="col-md-12" id="edit-package-body">

                    </div>



                </div>
                <div class="modal-footer">
                    <button type="button" onclick="AddEditItemsToPackage()" class="btn btn-info float-right add-more-check-list" > Add more </button>
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                    <button type="submit" hidden id="edit_package_form_submit"  class="btn btn-primary">Create</button>
                    <button type="button" onclick="EditPackageForm()"  class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>


@push('scripts')




    <script>

        // multi select box
        $('.edit_multi_heads').select2();

        var item = 0;

        function EditPackageForm()
        {

            document.getElementById('edit_package_form_submit').click();

        }

        function AddEditItemsToPackage()
        {

            var item_html = '<div class="form-row fields-body" data-value="'+item+'" id="edit_item_'+item+'">'+
                '<div id="'+item+'" onclick="RemoveEditItemField(this.id)" class="form-group col-md-12 ite-close-icon show-finger">'+
                '<i class="fa fa-close"></i>'+
                '</div>'+
                '<div class="form-group col-md-6" >'+
                '<label>Key <span class="text-danger">*</span></label>'+
                '<input type="text" placeholder="Key" class="form-control" name="key[]"   required>'+
                '</div>'+
                '<div class="form-group col-md-6">'+
                '<label> Item <span class="text-danger">*</span></label>'+
                '<input type="text" placeholder="Item" class="form-control" name="item[]" required>'+
                '</div>'+
                '</div>';

            $('#edit-package-body').append(item_html);

            item++;



        }

        function RemoveEditItemField(id)
        {

            $('#edit_item_'+id).remove();

        }


        function  SetEditPackage(data)
        {
            $('#edit-package-body').empty();
            var d = new Date(data.package.updated_at);
            var date = d.getUTCFullYear()+"-"+d.getUTCMonth()+'-'+d.getUTCDate()+' '+d.getUTCHours()+':'+d.getUTCMinutes();
            document.getElementById('edit_package_title').innerText = data.package.package_name+" Last Update "+date;
            document.getElementById('package_edit_form').setAttribute('action','/panel/package/updated/'+data.package.package_id);
            document.getElementById('edit_package_name').value = data.package.package_name

            var data_head = data.package_head;


            if(typeof  data_head === "object")
            {
                var temp_heads = []

                for(var i = 0 ; i < data_head.length ; i++)
                {

                    temp_heads.push(data_head[i].head_id);

                }

                var $unbindMulti = $(".edit_multi_heads").select2();

                $unbindMulti.val(temp_heads).trigger("change");

            }

            var data = JSON.parse(data.package.package_data);

            if(data !== null)
            {
                var data_html = "";

                var j = 0;

                for(var i = 0 ; i < data.length ; i++)
                {
                    for (let k in data[i]) {

                         j = i;

                        data_html =  '<div class="form-row fields-body" data-value="'+i+'" id="edit_item_'+i+'">'+
                            '<div id="'+i+'" onclick="RemoveEditItemField(this.id)" class="form-group col-md-12 ite-close-icon show-finger">'+
                            '<i class="fa fa-close"></i>'+
                            '</div>'+
                            '<div class="form-group col-md-6" >'+
                            '<label>Key <span class="text-danger">*</span></label>'+
                            '<input type="text" placeholder="Key" class="form-control" name="key[]"  value="'+k+'" required>'+
                            '</div>'+
                            '<div class="form-group col-md-6">'+
                            '<label> Item <span class="text-danger">*</span></label>'+
                            '<input type="text" placeholder="Item" class="form-control" name="item[]" value="'+data[i][k]+'" required>'+
                            '</div>'+
                            '</div>';

                    }

                    j++;
                    $('#edit-package-body').append(data_html);
                }

                item = j;


            }






            document.getElementById('edit_package_button').click();
        }


        function selectElement(id, valueToSelect,valueToRemove) {
            let element = document.getElementById(id);
            element.value = valueToSelect;
            element.dispatchEvent(new Event('change'))
        }






    </script>


@endpush
