@push('head')

    <link rel="stylesheet" href="{{asset('template_assets')}}/vendor/select2/css/select2.min.css">

@endpush

<button type="button" class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target=".bd-example-modal-lg">Create</button>

<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create New Package</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>
            <form action="{{route('panel.package.created')}}" method="POST"  id="package_create_form">

                @csrf

                <div class="modal-body" id="model-body" >


                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Package Name <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Full Package Name" class="form-control" name="package_name" required>
                        </div>
                    </div>

                    <div class="form-row">

                        <div class="form-group col-md-6">
                            <label>Assign Head to Package</label>

                            <select class="heads-select" name="heads[]" multiple="multiple">

                                @forelse(GetHeads() as $list)

                                    <option value="{{$list['head_id']}}"> {{$list['head_name']}}   </option>

                                @empty


                                @endforelse

                            </select>

                        </div>


                    </div>




                    <div class="form-row fields-body" data-value="1" id="item_1">

                        <div class="form-group col-md-6" >
                            <label> Key <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Key" class="form-control" name="key[]"   required>
                        </div>

                        <div class="form-group col-md-6">
                            <label> Item <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Item" class="form-control" name="item[]" required>
                        </div>

                    </div>






                </div>
                <div class="modal-footer">
                    <button type="button" onclick="AddItemsToPackage()" class="btn btn-info float-right add-more-check-list" > Add more </button>
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                    <button type="submit" hidden id="create_package_form_submit"  class="btn btn-primary">Create</button>
                    <button type="button" onclick="CreatePackageForm()"  class="btn btn-primary">Create</button>
                </div>
            </form>
        </div>
    </div>
</div>


@push('scripts')

    <script src="{{asset('template_assets')}}/vendor/select2/js/select2.full.min.js"></script>

    <script>

        // multi select box
        $('.heads-select').select2();

        function CreatePackageForm()
        {


            document.getElementById('create_package_form_submit').click();


        }

        function AddItemsToPackage()
        {

            var item = 2;

            var item_html = '<div class="form-row fields-body" data-value="'+item+'" id="item_'+item+'">'+
                            '<div id="'+item+'" onclick="RemoveItemField(this.id)" class="form-group col-md-12 ite-close-icon show-finger">'+
                            '<i class="fa fa-close"></i>'+
                            '</div>'+
                            '<div class="form-group col-md-6" >'+
                            '<label>Key <span class="text-danger">*</span></label>'+
                            '<input type="text" placeholder="Key" class="form-control" name="key[]"   required>'+
                            '</div>'+
                            '<div class="form-group col-md-6">'+
                            '<label> Item <span class="text-danger">*</span></label>'+
                            '<input type="text" placeholder="Item" class="form-control" name="item[]" required>'+
                            '</div>'+
                            '</div>';

            $('#model-body').append(item_html);

            item++;



        }

        function RemoveItemField(id)
        {

            console.log(id);

            $('#item_'+id).remove();

        }



    </script>


@endpush
