@extends('panel.layouts.app')

@push('head')

    <!-- Datatable -->
    <link href="{{asset('template_assets')}}/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

@endpush

@section('body')

    <div class="row">



        <div class="col-12">

            <div class="card">

                <div class="card-body">

                    @can('package-manage')
                    @include('panel.packages.model.create')
                    @endcan

                    <div class="table-responsive">
                        <table id="example3" class="display min-w850">
                            <thead>
                            <tr>
                                <th></th>
                                <th>Name</th>
                                <th>Total Sales</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php($counter = 1)
                            @forelse($packages as $list)
                            <tr>

                                <td>{{$counter++}}</td>
                                <td>{{$list->package_name}}</td>
                                <td></td>
                                <td>{{$list->created_at}}</td>
                                <td>

                                    <div class="d-flex">

                                        <div class="col">
                                            <button title="Show Package" onclick="ViewPackage('{{$list->package_id}}')"   class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-eye"></i></button>
                                        </div>


                                        @can('package-manage')
                                        <div class="col">
                                            <button title="Edit Package" onclick="EditPackage('{{$list->package_id}}')"  class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-edit"></i></button>
                                        </div>

                                        <div class="col">
                                            <button title="Remove Package, it may effects your reports." onclick="DeletePackage('{{$list->package_id}}','{{$list->package_name}}')"  class="btn btn-danger shadow btn-xs sharp"><i class="fa fa-trash"></i></button>
                                        </div>
                                            @endcan

                                    </div>


                                </td>

                            </tr>
                            @empty

                            @endforelse


                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>



@include('panel.packages.model.view')


    @can('package-manage')

    @include('panel.packages.model.edit')
    @include('panel.packages.model.delete')
    @endcan


@endsection


@push('scripts')

    <!-- Datatable -->
    <script src="{{asset('template_assets')}}/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/datatables.init.js"></script>


    <script>
   var SITEURL = "{{ url('/') }}";

        function ViewPackage(package_id)
        {
            $.ajax({


                type: 'GET',
                url:  SITEURL +  "/panel/package/view/"+package_id,
                success: function (data) {
                    SetViewPackage(JSON.parse(data));
                }

            });

        }

        @can('package-manage')
        function EditPackage(package_id)
        {
            $.ajax({


                type: 'GET',
                url:  SITEURL + "/panel/package/view/"+package_id,
                success: function (data) {
                    console.log(JSON.parse(data));
                    SetEditPackage(JSON.parse(data));
                }

            });

        }

        function  DeletePackage(id,name)
        {

            document.getElementById('delete_package_form').setAttribute('action','/panel/package/destroy/'+id);
            document.getElementById('delete_package_title').innerText = 'Deleting '+name;
            document.getElementById('delete-model-body').innerText = 'Are you sure you want to delete ?';

            document.getElementById('delete_package_button').click();
        }
        @endcan

    </script>


@endpush
