<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>{{env('APP_NAME')}} | @yield('title')</title>
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="{{asset('template_assets')}}/images/logo-56x56.png">
    <link href="{{asset('template_assets')}}/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/vendor/owl-carousel/owl.carousel.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

    @stack('head')

    <link rel="stylesheet"  href="{{asset('css/custom_css_defined.css')}}">


</head>
<body>

<!--*******************
    Preloader start
********************-->

<div id="preloader">
    <div class="sk-three-bounce">
        <div class="sk-child sk-bounce1"></div>
        <div class="sk-child sk-bounce2"></div>
        <div class="sk-child sk-bounce3"></div>
    </div>
</div>
<!--*******************
    Preloader end
********************-->

<!--**********************************
    Main wrapper start
***********************************-->
<div id="main-wrapper">

    <!--**********************************
        Nav header start
    ***********************************-->
    <div class="nav-header">
        <a href="{{route('panel.dashboard')}}" class="brand-logo">
            <img class="logo-abbr" src="{{asset('template_assets')}}/images/logo-56x56.png" alt="">
{{--            <img class="logo-compact" src="{{asset('template_assets')}}/images/logo-text.png" alt="">--}}
{{--            <img class="brand-title" src="{{asset('template_assets')}}/images/logo-text.png" alt="">--}}
            <h1 class="brand-title" style="white-space: nowrap; font-weight: bold"> {{ WebsiteData()['title']  }} </h1>


        </a>

        <div class="nav-control">
            <div class="hamburger">
                <span class="line"></span><span class="line"></span><span class="line"></span>
            </div>
        </div>
    </div>
    <!--**********************************
        Nav header end
    ***********************************-->



    <!--**********************************
        Header start
    ***********************************-->

    @include('panel.layouts.top_navbar')
    <!--**********************************
        Header end ti-comment-alt
    ***********************************-->

    <!--**********************************
        Sidebar start
    ***********************************-->
    @include('panel.layouts.side_navbar')
    <!--**********************************
        Sidebar end
    ***********************************-->

    <!--**********************************
        Content body start
    ***********************************-->
    <div class="content-body">

        <!-- row -->
        <div class="container-fluid {{--custom-container-card--}}">

             @yield('body')

        </div>

    </div>
    <!--**********************************
        Content body end
    ***********************************-->

    <!--**********************************
        Footer start
    ***********************************-->
    <div class="footer">
        <div class="copyright">
            <p>Copyright © Designed &amp; Developed by <a href="https://asifkhalid.com/" target="_blank">Muhammad Asif <b>AKA L30</b> </a> 2022</p>
        </div>
    </div>
    <!--**********************************
        Footer end
    ***********************************-->

    <!--**********************************
       Support ticket button start
    ***********************************-->

    <!--**********************************
       Support ticket button end
    ***********************************-->


</div>
<!--**********************************
    Main wrapper end
***********************************-->

<!--**********************************
    Scripts
***********************************-->
<!-- Required vendors -->

<script src="{{asset('template_assets')}}/vendor/global/global.min.js"></script>
<script src="{{asset('template_assets')}}/vendor/bootstrap-select/dist/js/bootstrap-select.min.js"></script>
<script src="{{asset('template_assets')}}/js/custom.min.js"></script>
<script src="{{asset('template_assets')}}/js/deznav-init.js"></script>
<script src="{{asset('template_assets')}}/vendor/owl-carousel/owl.carousel.js"></script>
<script>
    function carouselReview(){
        /*  event-bx one function by = owl.carousel.js */
        jQuery('.event-bx').owlCarousel({
            loop:true,
            margin:30,
            nav:true,
            center:true,
            autoplaySpeed: 3000,
            navSpeed: 3000,
            paginationSpeed: 3000,
            slideSpeed: 3000,
            smartSpeed: 3000,
            autoplay: false,
            navText: ['<i class="fa fa-caret-left" aria-hidden="true"></i>', '<i class="fa fa-caret-right" aria-hidden="true"></i>'],
            dots:true,
            responsive:{
                0:{
                    items:1
                },
                720:{
                    items:2
                },

                1150:{
                    items:3
                },

                1200:{
                    items:2
                },
                1749:{
                    items:3
                }
            }
        })
    }
    jQuery(window).on('load',function(){
        setTimeout(function(){
            carouselReview();
        }, 1000);
    });
</script>


@stack('scripts')


</body>
</html>
