
<!-- Button trigger modal -->
<button type="button" hidden class="btn btn-info mb-2" id="modify_head_button" data-toggle="modal" data-target="#editHeadModel">Modifying  Head</button>
<!-- Modal -->
<div class="modal fade" id="editHeadModel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="edit_head_name_title"></h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>

            <form method="post" id="edit_head_form">

                @csrf

                <div class="modal-body">

                    <div class="form-row">

                        <div class="form-group col-lg-12">
                            <label>Head Name <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Head Name" class="form-control" name="head_name" id="edit_head_name" onchange="" required>

                        </div>

                        <div class="form-group col-lg-12">
                            <label> Parent Head  </label>
                            <select class="form-control default-select" id="edit_head_parent" onchange="" name="head_parent" >

                                <option value >Choose Parent Head</option>

                                @foreach($heads as $key => $list)
                                    <option data-value="{{json_encode($list)}}" value="{{$list->head_id}}"> {{$list->head_name}}</option>
                                @endforeach

                            </select>

                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>

            </form>

        </div>
    </div>
</div>


@push('scripts')

    <script type="text/javascript">

        function EditHead(head_id,head_name,parent_head_id,parent_head_name)
        {

            document.getElementById('edit_head_name_title').innerText = "Modify the "+head_name+" head";
            document.getElementById('edit_head_name').value = head_name;

            document.getElementById('edit_head_form').setAttribute('action', '/panel/data/head-updated/'+head_id);

            document.getElementById('modify_head_button').click();


            selectElement('edit_head_parent', parent_head_id);


        }



    </script>

@endpush
