<!-- Large modal -->
<button type="button" class="btn btn-primary mb-2" data-toggle="modal" data-target=".bd-example-modal-lg">Create Check List</button>

<div class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Check List</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>

            <form action="{{route('panel.data.check.created')}}" method="POST">
                @csrf
            <div class="modal-body" id="check_list">

                <div class="form-row">

                    <div class="form-group col-lg-6">
                        <label>Check Head</label>
                        <select class="form-control default-select" id="check_head" name="head_id" required>
                            <option selected="">Choose Check Head</option>
                            @foreach($heads as $key => $list)
                                @if( $list->check_list_count !== 0)
                                @continue
                                @endif
                                <option data-value="{{json_encode($list)}}" value="{{$list->head_id}}"> {{$list->head_name}}</option>
                            @endforeach
                        </select>
                    </div>

                </div>

                <div class="form-row fields-body" data-value="1" id="field_1" >

                    <div class="form-group col-lg-12">

                        <div class="form-group col-lg-12" style="margin-top: 5px;">
                            <input type="text" placeholder="Check Name" id="check_name_1" onchange="FixCheckOption(this.id)" class="form-control" name="check_name[]" required>
                        </div>

                        <div class="input-group col-lg-12">
                            <input  onkeydown="return /[a-z, -]/i.test(event.key)" onchange="FixCheckOption(this.id)" type="text" placeholder="Check Option Seperated by Comma" id="check_option_1" class="form-control" name="check_option[]" required>
                            <div class="input-group-append">
                                <button hidden class="btn btn-danger" type="button">X</button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="modal-footer">

                <button type="button" onclick="AddMoreCheckList()" class="btn btn-info float-right add-more-check-list" > Add more </button>
                <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Save changes</button>
            </div>

            </form>

        </div>
    </div>
</div>


@push('scripts')


    <script>

        var field_id =  2;




        function AddMoreCheckList()
        {

            var field_html =    '<div class="form-row fields-body" data-value="'+field_id+'" id="field_'+field_id+'" >'+
                                    '<div class="form-group col-lg-12">'+

                                        '<div class="form-group col-lg-12" style="margin-top: 5px;">'+
                                             '<input type="text" placeholder="Check Name" id="check_name_'+field_id+'" onchange="FixCheckOption(this.id)" class="form-control" name="check_name[]" required>'+
                                        '</div>'+

                                        '<div class="input-group col-lg-12">'+
                                            '<input type="text" onkeydown="return /[a-z, -]/i.test(event.key)" onchange="FixCheckOption(this.id)"  placeholder="Check Option Seperated by Comma" id="check_option_'+ field_id+'" class="form-control" name="check_option[]" required>'+

                                            '<div class="input-group-append">'+
                                                 '<button class="btn btn-danger" onclick="RemoveCheckList('+field_id+')" type="button">X</button>'+
                                            '</div>'+

                                        '</div>'+

                                    '</div>'+
                                '</div>';


                $('#check_list').append(field_html);

                field_id++;



        }

        function RemoveCheckList(id)
        {
           $('#field_'+id).remove();

        }

    </script>

@endpush
