@extends('panel.layouts.app')

@push("head")

    <link rel="stylesheet" href="{{asset('css/custom_css_defined.css')}}">

    <!-- Datatable -->
    <link href="{{asset('template_assets')}}/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

@endpush

@section('body')


    <div class="row">

        <div class="col-lg-12">
            <div class="card">
                <div class="card-header border-0 pb-0">


                    @can('data-manage')

                    @include('panel.data.models.create_head_model')

                    @include('panel.data.models.create_item_check_model')

                   @endcan

                </div>


                <div class="card-body">


                    <div class="table-responsive">
                        <table id="example3" class="display min-w850">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Head Name</th>
                                <th>Parent Head Name</th>
                                <th>Total Checks</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php($head_count = 1)
                            @foreach($heads as $list)

                              <tr>
                                <td>{{$head_count++}}</td>
                                <td>{{ $list->head_name}}</td>
                                <td>{{ $list->parent_head_name ?? "N\A" }}</td>
                                <td>{{ $list->check_list_count ?? "N\A" }}</td>
                                <td>{{$list->created_at->diffForHumans()}} <br> {{   $list->created_at}}</td>
                                <td>

                                    <div class="d-flex">

                                        @can('data-manage')

                                        <div class="col">
                                            <button title="Edit Head" onclick="EditHead('{{ $list->head_id}}','{{ $list->head_name}}','{{ $list->parent_head_id}}','{{ $list->parent_head_name}}')" class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-pencil"></i></button>
                                        </div>

                                        <div class="col">
                                            <button title="Edit Head's Data" onclick="EditCheckList('{{ $list->head_id}}','{{ $list->head_name}}')" class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-edit"></i></button>
                                        </div>

                                        <div class="col">
                                           <button title="Remove Head and Its Data" onclick="DeleteHead('{{$list->head_id}}','{{$list->head_name}}')"   class="btn btn-danger shadow btn-xs sharp"><i class="fa fa-trash"></i></button>
                                       </div>

                                        @endcan

                                    </div>

                                </td>

                             </tr>

                            @endforeach


                            </tbody>
                        </table>
                    </div>

                </div>

                <div class="card-footer border-0 pt-0">
                    <p class="card-text d-inline">Card footer</p>
                    <a href="javascript:void(0)" class="card-link float-right">Card link</a>
                </div>
            </div>
        </div>



    </div>


    @can('data-manage')
    @include('panel.data.models.delete_head_model')
    @include('panel.data.models.edit_head_model')
    @include('panel.data.models.edit_item_check_model')
    @endcan

@endsection

@push('scripts')

    <!-- Datatable -->
    <script src="{{asset('template_assets')}}/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/datatables.init.js"></script>

    <script>
     var SITEURL = "{{ url('/') }}";

        
        @can('data-manage')
        function EditCheckList(head_id,head_name)
        {
            document.getElementById('edit_check_list_title').innerText = "Modifying "+head_name+" Check List";
            document.getElementById('edit_check_list_form').setAttribute('action','/panel/data/check-update/'+head_id);

            selectElement('edit_check_head', head_id);

            $.ajax({

               url:    SITEURL +  "/panel/data/check-edit/"+head_id,
               method: "GET",
                success: function (data) {

                        CheckListForEdit(data);

                }


            });

            document.getElementById('edit-check-list-model').click();

        }

        function DeleteHead(head_id,head_name)
        {
            document.getElementById('delete-model-title').innerText = "Deleting "+head_name;

            document.getElementById('delete_head_name').value = head_name;

            $("#delete_head_form").attr('action', '/panel/data/destroy-head/'+head_id);

            document.getElementById('delete_head_button').click();

        }
        @endcan

        function selectElement(id, valueToSelect,valueToRemove) {
            let element = document.getElementById(id);
            element.value = valueToSelect;
            element.dispatchEvent(new Event('change'))
        }

        function FixCheckOption(id)
        {

            var string = document.getElementById(id).value.replace(/^\s+|\s+$/gm,'').replace(/\s+/g, ' ').trim();

            string = string.replace('/', '-');

            document.getElementById(id).value = string;



        }

    </script>

@endpush
