<button type="button" id="view-customer-button" hidden class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target=".view-customer-model">View</button>

<div class="modal fade view-customer-model" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="view_customer_model_title"></h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>

                <div class="modal-body">


                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Full Name <span class="text-danger">*</span></label>
                            <input readonly type="text" placeholder="Full Name" class="form-control"  id="view_customer_name" required>
                        </div>

                        <div class="form-group col-md-6" >
                            <label>Image</label>
                            <div class="input-group mb-3">
                              <img src="" width="100" height="100" id="view_customer_image">
                            </div>

                        </div>
                    </div>

                    <div class="form-row">

                        <div class="form-group col-md-6" id="edit_email_div">
                            <label>Email <span class="text-danger">*</span></label>
                            <input readonly type="email" placeholder="Email" class="form-control" id="view_customer_email"  >
                        </div>

                        <div class="form-group col-md-6">
                            <label>Gender</label>
                            <select class="form-control default-select" id="view_customer_gender"  >

                                <option >Gender Not Selected</option>
                                <option value="male">Male</option>
                                <option value="female">Female</option>

                            </select>

                        </div>



                    </div>


                    <div class="form-row">


                        <div class="form-group col-md-3">
                            <label>Country Code</label>
                            <input readonly type="number" placeholder="Country Code"  class="form-control"  id="view_customer_country_code">

                        </div>

                        <div class="form-group col-md-5" id="edit_contact_div">
                            <label>Mobile Number</label>
                            <input readonly type="number" placeholder="Mobile Number" class="form-control"  id='view_customer_contact'>
                        </div>

                    </div>


                    <div class="form-group">
                        <label>Address</label>
                        <input readonly type="text" placeholder="Complete User Address" class="form-control"  id="view_customer_address">
                    </div>


                    <div class="form-group">
                        <label>Description</label>
                        <textarea readonly class="form-control"  id="view_customer_description" style="height:100px"></textarea>
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                </div>

        </div>
    </div>
</div>


@push('scripts')


    <script>

        function  ViewCustomerModel(data)
        {

            var data = JSON.parse(data);

            document.getElementById('view_customer_name').value = data.customer_name;
            document.getElementById('view_customer_image').src = "{{asset('storage')}}/customers/"+data.customer_id+"/"+data.customer_image;
            document.getElementById('view_customer_email').value = data.customer_email;
            document.getElementById('view_customer_contact').value = data.customer_contact;
            document.getElementById('view_customer_address').value = data.customer_address;
            document.getElementById('view_customer_description').value = data.customer_description;
            document.getElementById('view_customer_model_title').innerText = " Modifying Customer "+data.customer_name;
            selectElement('view_customer_country_code',data.customer_country_code,'');
            selectElement('view_customer_gender',data.customer_gender,'');



            document.getElementById('view-customer-button').click();
        }


    </script>

@endpush
