<button type="button" id="edit-customer-button" hidden class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target=".edit-customer-model">Edit</button>

<div class="modal fade edit-customer-model" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="edit_customer_model_title"></h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>
            <form  method="post" enctype="multipart/form-data" id="customer_edit_form">

                @csrf
                <input type="hidden" name="customer_id"  id="edit_customer_id">

                <div class="modal-body">


                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Full Name <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Full Name" class="form-control" name="customer_name" id="edit_customer_name" required>
                        </div>

                        <div class="form-group col-md-6">
                            <label>Image</label>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">Upload</span>
                                </div>
                                <div class="custom-file" style="overflow: hidden">
                                    <input type="file" class="custom-file-input" name="customer_image">
                                    <label class="custom-file-label">Choose file</label>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="form-row">

                        <div class="form-group col-md-6" id="edit_email_div">
                            <label>Email <span class="text-danger">*</span></label>
                            <input type="email" placeholder="Email" class="form-control" name="customer_email" id="edit_customer_email" onchange="EditEmailValidator()" >
                        </div>

                        <div class="form-group col-md-6">
                            <label>Gender</label>
                            <select class="form-control default-select" id="edit_customer_gender" name="customer_gender" >

                                <option >Choose Gender</option>
                                <option value="male">Male</option>
                                <option value="female">Female</option>

                            </select>

                        </div>



                    </div>


                    <div class="form-row">

                        <div class="form-group col-md-4">
                            <label>Country </label>
                            <select class="form-control default-select"  onchange="EditGetCountryDail()" name="country" id="edit_country_data">

                                <option selected="">Choose Country</option>
                                @foreach(GetCountryData() as $key => $list)
                                    <option data-value="{{json_encode($list)}}" value="{{$list->FIFA}}">{{$list->official_name_en}}</option>
                                @endforeach

                            </select>

                        </div>

                        <div class="form-group col-md-3">
                            <label>Country Code</label>
                            <input type="number" placeholder="Country Code"  class="form-control" name="customer_country_code" id="edit_customer_country_code">

                        </div>

                        <div class="form-group col-md-5" id="edit_contact_div">
                            <label>Mobile Number</label>
                            <input type="number" placeholder="Mobile Number" class="form-control" onchange="EditMobileNumberValidator()" name="customer_contact" id='edit_customer_contact'>
                        </div>

                    </div>


                    <div class="form-group">
                        <label>Address</label>
                        <input type="text" placeholder="Complete User Address" class="form-control" name="customer_address" id="edit_customer_address">
                    </div>


                    <div class="form-group">
                        <label>Description</label>
                        <textarea class="form-control" name="customer_description" id="edit_customer_description" style="height:100px"></textarea>
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                    <button type="submit" hidden id="edit_customer_submit_button"  class="btn btn-primary">Save changes</button>
                    <button type="button" onclick="EditCustomerForm()"  class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>


@push('scripts')


    <script>
   var SITEURL = "{{ url('/') }}";


        function  EditCustomerForm()
        {
            document.getElementById('edit_customer_submit_button').click();

        }

        function EditGetCountryDail()
        {
            var user_data  = JSON.parse($('#edit_country_data option:checked').attr('data-value'));

            document.getElementById('edit_customer_country_code').value = user_data.Dial;

        }

        function EditEmailValidator()
        {
            var customer_id = document.getElementById('edit_customer_id').value;

            $('#edit-email-span').remove();

            var edit_customer_email = document.getElementById('edit_customer_email').value;

            $.ajax({

                type:'GET',
                url:    SITEURL +  "/panel/customer/get-by-email/"+edit_customer_email+"/"+customer_id,
                success:function(data) {

                    if(typeof data === "object")
                    {
                        $('#edit_email_div').append('<span id="edit-email-span" class=" text-danger  fadeInUp">email already taken</span>');
                    }

                }

            });

            return "";

        }


        function EditMobileNumberValidator()
        {
            var customer_id = document.getElementById('edit_customer_id').value;

            try {

                $('#edit-contact-span').empty();

            }catch (e) {

            }

            var code = document.getElementById('edit_customer_country_code').value;
            var contact = document.getElementById('edit_customer_contact').value;

            $.ajax({


                type:'GET',
                url:   SITEURL +  "/panel/customer/get-by-contact/"+code+"/"+contact+"/"+customer_id,
                success:function(data) {

                    console.log(data);

                    if(typeof data === "object" )
                    {
                        $('#edit_contact_div').append('<span id="edit-contact-span" class=" text-danger  fadeInUp">Number already taken</span>');
                    }

                }

            });



        }

        function  EditCustomerModel(data)
        {

            var data = JSON.parse(data);

            document.getElementById('customer_edit_form').setAttribute('onclick','');

            document.getElementById('edit_customer_id').value = data.customer_id;
            document.getElementById('edit_customer_name').value = data.customer_name;
            document.getElementById('edit_customer_email').value = data.customer_email;
            document.getElementById('edit_customer_contact').value = data.customer_contact;
            document.getElementById('edit_customer_address').value = data.customer_address;
            document.getElementById('edit_customer_description').value = data.customer_description;
            document.getElementById('edit_customer_model_title').innerText = " Modifying Customer "+data.customer_name;
            selectElement('edit_customer_country_code',data.customer_country_code,'');
            selectElement('edit_customer_gender',data.customer_gender,'');

            document.getElementById('customer_edit_form').setAttribute('action','/panel/customer/updated/'+data.customer_id);


            document.getElementById('edit-customer-button').click();
        }



    </script>

@endpush


