<button type="button" id="create_customer_model_button" class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target=".create_customer_model">Create</button>

<div class="modal fade create_customer_model" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create New User</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>
            <form action="{{route('panel.customer.created')}}" method="POST" enctype="multipart/form-data" id="user_create_form">

                @csrf

                <div class="modal-body">


                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Full Name <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Full Name" class="form-control" name="customer_name" >
                        </div>

                        <div class="form-group col-md-6">
                            <label>Image</label>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">Upload</span>
                                </div>
                                <div class="custom-file" style="overflow: hidden">
                                    <input type="file" class="custom-file-input" name="customer_image" id="create_customer_image">
                                    <label class="custom-file-label">Choose file</label>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="form-row">

                        <div class="form-group col-md-6" id="email_div">
                            <label>Email </label>
                            <input type="email" placeholder="Email" class="form-control" name="customer_email" id="customer_email" onchange="EmailValidator()">
                        </div>

                        <div class="form-group col-md-6">
                            <label>Gender</label>
                            <select class="form-control default-select" name="customer_gender" >

                                <option value >Choose Gender</option>
                                <option value="male">Male</option>
                                <option value="female">Female</option>

                            </select>

                        </div>



                    </div>


                    <div class="form-row">

                        <div class="form-group col-md-4">
                            <label>Country </label>
                            <select class="form-control default-select" id="country_data" onchange="GetCountryDail()" name="country">

                                <option selected="">Choose Country</option>
                                @foreach(GetCountryData() as $key => $list)
                                    <option data-value="{{json_encode($list)}}" value="{{$list->FIFA}}">{{$list->official_name_en}}</option>
                                @endforeach

                            </select>

                        </div>

                        <div class="form-group col-md-3">
                            <label>Country Code</label>
                            <input type="number" placeholder="Country Code" id="country_code" class="form-control" name="customer_country_code">

                        </div>

                        <div class="form-group col-md-5" id="contact_div">
                            <label>Mobile Number</label>
                            <input type="number" placeholder="Mobile Number" id="contact" class="form-control" onchange="MobileNumberValidator()" name="customer_contact">
                        </div>

                    </div>


                    <div class="form-group">
                        <label>Address</label>
                        <input type="text" placeholder="Complete User Address" class="form-control" name="customer_address">
                    </div>


                    <div class="form-group">
                        <label>Description</label>
                        <textarea class="form-control" name="customer_description" id="description " style="height:100px"></textarea>
                    </div>


                </div>

                @if(Route::currentRouteName() === "panel.quick-check.index" || Route::currentRouteName() === "panel.quick-check.inprogress" )
                <input type="hidden" name="access_type" value="api">
                @endif

                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                    <button type="submit" hidden id="create_customer_form_submit"  class="btn btn-primary">Save changes</button>
                    <button type="button" onclick="CreateCustomerForm()"  class="btn btn-primary">Submit</button>
                </div>


            </form>
        </div>
    </div>
</div>




@push('scripts')


    <script>
   var SITEURL = "{{ url('/') }}";


        function  CreateCustomerForm()
        {
            @if(Route::currentRouteName() === "panel.quick-check.index" || Route::currentRouteName() === "panel.quick-check.inprogress" )


            let custom_form = document.getElementById("user_create_form");

            var formData = new FormData(custom_form);


            $.ajax({

                url: "{{route('panel.customer.created')}}",
                type: "POST",
                contentType: false,
                processData: false,
                data: formData,
                success: function(data, textStatus, jqXHR){

                    if(typeof data.customer_name !== "undefined")
                    {
                        var newOption = new Option(data.customer_name, data.customer_id, true, true);

                        $('#customer-select').append(newOption).trigger('change').select2();

                        $('.create_customer_model').modal('toggle');

                        @if( Route::currentRouteName() === "panel.quick-check.inprogress")

                        SentUpdatedInspection('customer-select',' customer updated ');

                        @endif

                    }


                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(jqXHR, textStatus, errorThrown);
                }
            })


            @else

            document.getElementById('create_customer_form_submit').click();

            @endif

        }

        function GetCountryDail()
        {
            var user_data  = JSON.parse($('#country_data option:checked').attr('data-value'));

            document.getElementById('country_code').value = user_data.Dial;

        }

        function EmailValidator()
        {
            $('#email-span').remove();

            var customer_email = document.getElementById('customer_email').value;

            $.ajax({

                type:'GET',
                url:    SITEURL +  "/panel/customer/get-by-email/"+customer_email+"/null",
                success:function(data) {

                    if(typeof data === "object")
                    {
                        $('#email_div').append('<span id="email-span" class=" text-danger  fadeInUp">email already taken</span>');
                    }

                }

            });

            return "";

        }


        function MobileNumberValidator()
        {

            try {

                $('#contact-span').empty();

            }catch (e) {

            }

            var code = document.getElementById('country_code').value;
            var contact = document.getElementById('contact').value;

            $.ajax({


                type:'GET',
                url:    SITEURL +  "/panel/customer/get-by-contact/"+code+"/"+contact+"/null",
                success:function(data) {


                    if(typeof data === "object" )
                    {
                        $('#contact_div').append('<span id="contact-span" class=" text-danger  fadeInUp">Number already taken</span>');
                    }

                }

            });



        }


    </script>

@endpush
