@extends('panel.layouts.app')

@push("head")

    <link rel="stylesheet" href="{{asset('css/custom_css_defined.css')}}">

    <!-- Datatable -->
    <link href="{{asset('template_assets')}}/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

@endpush

@section('body')

    <div class="row">

        <div class="col-lg-12">
            <div class="card">
                <div class="card-header border-0 pb-0">

                @include('panel.customers.model.create_model')

                </div>

                <div class="card-body">


                    <div class="table-responsive">
                        <table id="example3" class="display min-w850">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Customer Name</th>
                                <th>Customer Contact</th>
                                <th>Customer Email</th>
                                <th>Last Check</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php($counter = 1)
                            @forelse($customers as $list)
                            <tr>
                                <?php

                                $user_image = asset('template_assets')."/images/profile/small/pic1.jpg";
                                $destinationPath = 'customers/'.$list->customer_id.'/'.$list->customer_image;

                                if(Storage::exists("public/".$destinationPath))
                                {
                                    $user_image = asset('storage/'.$destinationPath);
                                }

                                ?>

                                <td>{{$counter++}}</td>
                                <td><img class="rounded-circle" width="35" src="{{$user_image ?? ""}}" alt=""> {{$list->customer_name}}</td>
                                <td>{{ "+".(int)$list->customer_country_code."-".(int)$list->customer_contact}}</td>
                                <td>{{$list->customer_email}}</td>
                                <td> N/A </td>
                                <td>
                                    <div class="d-flex">

                                        <div class="col">
                                            <a title="Show Customer" href="#" onclick="ViewCustomerModel('{{json_encode($list)}}')" class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-eye"></i></a>
                                        </div>

                                        <div class="col">
                                            <a title="Edit Customer" href="#" onclick="EditCustomerModel('{{json_encode($list)}}')" class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-pencil"></i></a>
                                        </div>

                                        <div class="col">
                                            <a  title="Remove Customer" href="#" onclick="DestroyCustomerModel('{{$list->customer_id}}','{{$list->customer_name}}')" class="btn btn-danger shadow btn-xs sharp"><i class="fa fa-trash"></i></a>
                                        </div>

                                    </div>


                                </td>

                            </tr>
                             @empty

                            @endforelse

                            </tbody>
                        </table>
                    </div>

                </div>

                <div hidden class="card-footer border-0 pt-0">
                    <p class="card-text d-inline">Card footer</p>
                    <a href="javascript:void(0)" class="card-link float-right">Card link</a>
                </div>

            </div>
        </div>
    </div>

    @include('panel.customers.model.destroy')
    @include('panel.customers.model.edit')
    @include('panel.customers.model.view')



@endsection

@push('scripts')

    <!-- Datatable -->
    <script src="{{asset('template_assets')}}/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/datatables.init.js"></script>

    <script >

        function DestroyCustomerModel(customer_id,$customer_name)
        {
            $('#remove_customer_name').remove();
            document.getElementById('destroy_customer_form').setAttribute('action','/panel/customer/destroy/'+customer_id);
            document.getElementById('delete-customer-model-title').innerText = "Removing customer "+$customer_name;
            $('#destroy_customer_form').append('<input id="remove_customer_name" type="hidden" name="customer_name" value="'+$customer_name+'" >');
            document.getElementById('customer-delete-button').click();

        }



        function selectElement(id, valueToSelect,valueToRemove) {
            let element = document.getElementById(id);
            element.value = valueToSelect;
            element.dispatchEvent(new Event('change'))
        }


    </script>

@endpush
