<button type="button" hidden id="edit-car-button" class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target=".edit-car-model">Create</button>

<div class="modal fade edit-car-model" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="car-edit-model-title"></h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>
            <form  method="POST" enctype="multipart/form-data" id="edit_cars_form">

                @csrf

                <input type="hidden" name="car_id" id="edit_car_id">

                <div class="modal-body">


                    <div class="form-row">

                        <div hidden class="form-group col-md-6">
                            <label>Car Name </label>
                            <input type="text" placeholder="Car Name" class="form-control" name="car_name" id="edit_car_name" >
                        </div>

                        <div class="form-group col-md-6">
                            <label>Car Mileage</label>
                            <input type="text" placeholder="Car Mileage" class="form-control" name="car_mileage"  id="edit_car_mileage">
                        </div>


                        <div class="form-group col-md-6">
                            <label>Image</label>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">Upload</span>
                                </div>
                                <div class="custom-file" style="overflow: hidden">
                                    <input type="file" class="custom-file-input" name="car_image" id="edit_car_image">
                                    <label class="custom-file-label">Choose file</label>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="form-row">

                        <div class="form-group col-md-6" id="edit-plate_number_div">
                            <label>Car Number Plate <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Car Number Plate" class="form-control" onchange="EditCarNumberPlateValidator()" name="car_plate_number" id="edit_car_number_plate"  required>
                        </div>

                        <div class="form-group col-md-6" id="email_div">
                            <label>Car Make  <span class="text-danger">*</span> </label>
                            <input type="text" onchange="CarMakeChange(this.id,'edit_car_model_list')" placeholder="Car Make" class="form-control" list="edit_car_make_list" name="car_make" id="edit_car_make" required >


                            <datalist id="edit_car_make_list">

                                @foreach(GetCarMakes() as $list)

                                    <option value="{{$list}}">

                                @endforeach

                            </datalist>



                        </div>

                        <div class="form-group col-md-6" id="email_div">
                            <label>Car Model</label>
                            <input type="text" onchange="CarModelChange(this.id,'edit_car_year_list','edit_car_make')" placeholder="Car Model" class="form-control" name="car_model" id="edit_car_model"  list="edit_car_model_list" >

                            <datalist id="edit_car_model_list">



                            </datalist>



                        </div>

                        <div class="form-group col-md-6" id="email_div">
                            <label>Car Year</label>
                            <input type="text" placeholder="Car Year" class="form-control" name="car_year" id="edit_car_year" list="edit_car_year_list" >

                            <datalist id="edit_car_year_list">

                            </datalist>






                        </div>

                        <div class="form-group col-md-6" id="email_div">
                            <label>Car VIN Number</label>
                            <input type="text" placeholder="Car VIN Number" class="form-control" name="car_vin_number" id="edit_car_vin_number" >
                        </div>

                        <div class="form-group col-md-6">
                            <label>Select Body Type</label>
                            <select class="form-control default-select" name="car_body_type" id="edit_car_body_type" >

                                <option value>Choose Body Type</option>

                                @foreach(GetBodyType() as $list)
                                    <option value="{{$list->cby_id}}">{{$list->cby_name}}</option>
                                @endforeach


                            </select>

                        </div>

                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                    <button type="submit" hidden id="edit_car_form_submit"  class="btn btn-primary">Save changes</button>
                    <button type="button" onclick="EditSubmitCarForm()"  class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>


@push('scripts')


    <script>
   var SITEURL = "{{ url('/') }}";

        function  EditCarNumberPlateValidator()
        {
            $('#edit-plate-number-span').remove();

            var plate_number =  document.getElementById('edit_car_number_plate').value;
            var edit_car_id = document.getElementById('edit_car_id').value;

            $.ajax({
                url:     SITEURL +  "/panel/cars/get-by-plate-number/"+plate_number+"/"+edit_car_id,
                method: 'GET',
                success: function(data) {

                    if(typeof data === "object")
                    {
                        $('#edit-plate_number_div').append('<span id="edit-plate-number-span" class=" text-danger  fadeInUp">plate number already exists</span>');
                    }

                }



            });

        }

        function EditCarButton(data)
        {

            var data = JSON.parse(data);

            document.getElementById('edit_car_name').value = data.car_name;
            document.getElementById('edit_car_mileage').value = data.car_mileage;
            document.getElementById('edit_car_number_plate').value = data.car_plate_number;
            document.getElementById('edit_car_make').value = data.car_make;
            document.getElementById('edit_car_model').value = data.car_model;
            document.getElementById('edit_car_year').value = data.car_year;
            document.getElementById('edit_car_vin_number').value = data.car_vin_number;
            document.getElementById('edit_car_id').value = data.car_id;

            selectElement('edit_car_body_type',data.car_body_type,'')


            document.getElementById('edit_cars_form').setAttribute('action', SITEURL + '/panel/cars/updated/'+data.car_id);


            document.getElementById('edit-car-button').click();
        }

        function EditSubmitCarForm()
        {
            document.getElementById('edit_car_form_submit').click();

        }





    </script>

@endpush
