<!-- Button trigger modal -->
<button type="button" hidden id="car-delete-button" class="btn btn-primary mb-2" data-toggle="modal" data-target="#DestroyCarModel">Delete</button>
<!-- Modal -->
<div class="modal fade" id="DestroyCarModel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="delete-car-model-title"></h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                </button>
            </div>

            <form id="destroy_car_form" method="post"  >
                @csrf

                <div class="modal-body">Are you sure you want to delete this car ?</div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Destroy</button>
                </div>

            </form>

        </div>
    </div>
</div>


@push('scripts')

    <script>

        function DeleteCarModel(car_id,car_name)
        {
            document.getElementById('destroy_car_form').setAttribute('action','/panel/cars/destroy/'+car_id);
            $('#delete_car_name').remove();
            $('#destroy_car_form').append('<input type="hidden" id="delete_car_name" name="car_name" value="'+car_name+'" >');
            document.getElementById('delete-car-model-title').innerText = "Removing car \""+car_name+"\"";
            document.getElementById('car-delete-button').click();
        }

    </script>

@endpush
