@extends('panel.layouts.app')

@push("head")

    <link rel="stylesheet" href="{{asset('css/custom_css_defined.css')}}">

    <!-- Datatable -->
    <link href="{{asset('template_assets')}}/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

@endpush

@section('body')

    <div class="row">

        <div class="col-lg-12">
            <div class="card">
                <div class="card-header border-0 pb-0">

                    @can('car-create')
                    @include('panel.cars.model.create')
                    @endcan

                </div>


                <div class="card-body">


                    <div class="table-responsive">
                        <table id="example3" class="display min-w850">
                            <thead>
                            <tr>
                                <th>#</th>
{{--                                <th>Car Name</th>--}}
                                <th>Car Plate Number</th>
                                <th>Car Make</th>
                                <th>Car Model</th>
                                <th>Car Year</th>
                                <th>Car VIN Number</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php($counter = 1)
                            @forelse($cars as $car)

                                <tr>
                                    <td>{{$counter++}}</td>
{{--                                    <td>{{$car->car_name}}</td>--}}
                                    <td>{{$car->car_plate_number}}</td>
                                    <td>{{$car->car_make}}</td>
                                    <td>{{$car->car_model}}</td>
                                    <td>{{$car->car_year}}</td>
                                    <td>{{$car->car_vin_number}}</td>
                                    <td>

                                        <div class="d-flex">


                                            <div class="col">
                                                <a title="Show Car" href="#" onclick="ViewCarButton('{{json_encode($car)}}')"  class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-eye"></i></a>
                                            </div>


                                            @can('car-edit')
                                            <div class="col">
                                                <a title="Edit Car" href="#" onclick="EditCarButton('{{json_encode($car)}}')"  class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-pencil"></i></a>
                                            </div>
                                            @endcan


                                            @can('car-delete')
                                            <div class="col">
                                                <a href="#" title="Remove Car" onclick="DeleteCarModel('{{$car->car_id}}','{{$car->car_name}}')" class="btn btn-danger shadow btn-xs sharp"><i class="fa fa-trash"></i></a>
                                            </div>
                                            @endcan

                                        </div>


                                    </td>

                                </tr>

                            @empty

                            @endforelse


                            </tbody>
                        </table>
                    </div>

                </div>

                <div hidden class="card-footer border-0 pt-0">
                    <p class="card-text d-inline">Card footer</p>
                    <a href="javascript:void(0)" class="card-link float-right">Card link</a>
                </div>

            </div>
        </div>



    </div>

    @can('car-delete')
    @include('panel.cars.model.delete')
    @endcan

    @can('car-edit')
    @include('panel.cars.model.edit')
    @endcan

    @include('panel.cars.model.view')



@endsection

@push('scripts')

    <!-- Datatable -->
    <script src="{{asset('template_assets')}}/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/datatables.init.js"></script>

    <script >

    var SITEURL = "{{ url('/') }}";


        function  CarModelChange(id,list_id,make_id)
        {



            $('#'+list_id).empty();

            var car_make = document.getElementById(make_id).value;
            var car_model = document.getElementById(id).value;

            $.ajax({

                url:   SITEURL +  '/helper/get-car-year/'+car_make+'/'+car_model,
                type: 'GET',
                success: function(data) {

                    Object.entries(data).forEach(entry => {
                        const [key, value] = entry;
                        $('#'+list_id).append("<option value='" + value.year + "'>")
                        // console.log(key,value);
                    });


                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(jqXHR, textStatus, errorThrown);
                }


            });


        }

        function CarMakeChange(id,list_id)
        {

            console.log(id,list_id);

            $('#'+list_id).empty();

            var car_make = document.getElementById(id).value;


            $.ajax({

                url:  SITEURL +  '/helper/get-car-model/'+car_make,
                type: 'GET',
                success: function(data) {

                    Object.entries(data).forEach(entry => {
                        const [key, value] = entry;
                        $('#'+list_id).append("<option value='" + value.model + "'>")
                    });

                },
                error: function(jqXHR, textStatus, errorThrown){
                    console.log(jqXHR, textStatus, errorThrown);
                }

            });

        }


        function selectElement(id, valueToSelect,valueToRemove) {
            let element = document.getElementById(id);
            element.value = valueToSelect;
            element.dispatchEvent(new Event('change'))
        }

    </script>

@endpush
