@extends('panel.layouts.app')

@push("head")

    <link rel="stylesheet" href="{{asset('css/custom_css_defined.css')}}">

    <!-- Datatable -->
    <link href="{{asset('template_assets')}}/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link href="{{asset('template_assets')}}/css/style.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet">

@endpush

@section('body')

    <div class="row">

        <div class="col-lg-12">
            <div class="card">
                <div class="card-header border-0 pb-0">

                    @can('body-create')
                    @include('panel.car_body_types.model.create')
                    @endcan

                </div>


                <div class="card-body">


                    <div class="table-responsive">
                        <table id="example3" class="display min-w850">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>Body Name</th>
                                <th>Last Update</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php($counter = 1)
                            @forelse($cby as $list)

                                <tr>
                                    <td>{{$counter++}}</td>
                                    <td>{{$list->cby_name}}</td>
                                    <td>{{$list->updated_at}}</td>
                                    <td>
                                        <div class="d-flex">


                                            <div class="col">
                                                <a  title="Show Body Type" href="#" onclick="ViewCarBodyType('{{json_encode($list)}}')"  class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-eye"></i></a>
                                            </div>


                                                @can('body-edit')
                                            <div class="col">
                                                <a title="Edit Body Type" href="#" onclick="EditCarBodyType('{{json_encode($list)}}')" class="btn btn-primary shadow btn-xs sharp mr-1"><i class="fa fa-pencil"></i></a>
                                            </div>
                                                @endcan

                                                @can('body-delete')
                                            <div class="col">
                                                <a title="Remove Body Type" href="#" onclick="DeleteCarBodyTypeModel('{{$list->cby_id}}','{{$list->cby_name}}')" class="btn btn-danger shadow btn-xs sharp"><i class="fa fa-trash"></i></a>
                                            </div>
                                                @endcan

                                        </div>

                                    </td>

                                </tr>

                            @empty


                            @endforelse



                            </tbody>
                        </table>
                    </div>

                </div>

                <div hidden class="card-footer border-0 pt-0">
                    <p class="card-text d-inline">Card footer</p>
                    <a href="javascript:void(0)" class="card-link float-right">Card link</a>
                </div>

            </div>
        </div>



    </div>

    @can('body-delete')
    @include('panel.car_body_types.model.delete')
    @endcan

    @can('body-edit')
    @include('panel.car_body_types.model.edit')
    @endcan


    @include('panel.car_body_types.model.view')



@endsection

@push('scripts')

    <!-- Datatable -->
    <script src="{{asset('template_assets')}}/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('template_assets')}}/js/plugins-init/datatables.init.js"></script>

    <script >


        function selectElement(id, valueToSelect,valueToRemove) {
            let element = document.getElementById(id);
            element.value = valueToSelect;
            element.dispatchEvent(new Event('change'))
        }

    </script>

@endpush
