<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class CreateAdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $user = User::create([
            'name' => 'Developer',
            'email' => 'admin@gmail.com',
            'username' => 'admin',
            'password' => bcrypt('123456'),
            'address' => 'House 1, Street 1, Los Angeles, LA',
            'country' => 'USA',
            'country_code' => '1',
            'contact' => '987654321',
            'gender' => 'male',
        ]);

        $role = Role::create(['name' => 'Admin']);

        $permissions = Permission::pluck('id','id')->all();

        $role->syncPermissions($permissions);

        $user->assignRole([$role->id]);
    }
}
