<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuickCheck extends Model
{
    use \Staudenmeir\EloquentHasManyDeep\HasRelationships;

    use HasFactory;

    protected $primaryKey = "qc_id";


    protected $fillable = [

        'car_id',
        'customer_id',
        'package_id',
        'custom_price',
        'inspection_data',
        'sms_sent',
        'start_at',
        'end_at',
        'interior',
        'exterior',
        'mechanical_electrical',
        'test_drive',
        'additional_note',
        'report_interior',
        'report_exterior',
        'report_mileage',
        'report_gcc',

    ];

    public function Car()
    {
       return $this->hasOne(Car::class,'car_id','car_id');
    }

    public function Customer()
    {
        return $this->hasOne(Customer::class,'customer_id','customer_id');
    }

    public function Package()
    {
        return $this->hasOne(Package::class,'package_id','package_id');
    }

    public function Logs()
    {
        return $this->hasMany(QuickCheckLog::class,'qc_id','qc_id')->orderBy('id','desc');
    }



}
