<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Car extends Model
{
    use HasFactory;

    protected $primaryKey = "car_id";

    protected $table ="cars";

    protected $fillable = [
        'car_name',
        'car_mileage',
        'car_plate_number',
        'car_make',
        'car_model',
        'car_year',
        'car_vin_number',
        'car_body_type',
        'car_image'
    ];

    public function CarBodyType()
    {
        return $this->hasOne(CarBodyType::class,'cby_id','car_body_type');
    }

}
