<?php

use App\Models\CarBodyType;
use App\Models\CarModelData;
use App\Models\Check_head;
use App\Models\Customer;
use App\Models\Package;
use App\Models\QuickCheck;
use App\Models\QuickCheckLog;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use TaylorNetwork\UsernameGenerator\Generator;
use App\Models\User;
use Twilio\Rest\Client;
use Carbon\Carbon;


function GetCountryData()
    {
        $temp_country_data = DB::table('country_data')->select('status','Dial','official_name_en','FIFA')->where('status',1)->whereNotIn('official_name_en',[""])->get();

        $country_data = [];

        foreach ($temp_country_data as $list)
        {
            $country_data[] = $list;
        }

        return $country_data;

}

function GetAllCountryData()
{
    $temp_country_data = DB::table('country_data')->select('status','Dial','official_name_en','FIFA')->whereNotIn('official_name_en',[""])->get();

    $country_data = [];

    foreach ($temp_country_data as $list)
    {
        $country_data[] = $list;
    }

    return $country_data;

}


    function UsernameGenerator($email = null)
    {

        $generator = new Generator();
        $generator->setDriver('email');
        $username = $generator->generate($email);

        return $username;

    }

//    quick check additional note get
    function GetQCADN($id)
    {
        return  QuickCheck::where('qc_id',$id)->select('additional_note','interior','exterior','mechanical_electrical','test_drive','report_mileage','report_interior','report_exterior','report_gcc','custom_price')->first();

    }


    function UsernameValidator( $username = null , $user_id = null)
    {

        $user = null;

        if(!empty($username) && (!empty($user_id) && ( $user_id !== "null" || $user_id === null ) ))
        {

            $user = User::where('username', $username)->select("username")->where('id',$user_id)->first();

        }
        elseif(!empty($username))
        {

            $user = User::where('username', $username)->select("username")->first();

        }


        return response($user);

    }

    function EmailValidator($email = null , $user_id = null)
    {

        $user = null;

        if(!empty($email) && (!empty($user_id) && ( $user_id !== "null" || $user_id === null ) ))
        {
            $user = User::where('email', $email)->select("email")->where('id',$user_id)->exists();
        }
        elseif(!empty($email))
        {

            $user = User::where('email', $email)->select("email")->exists();
        }


        return response($user);


    }

    function MobileNumberValidator($code = null, $contact = null ,$user_id = null)
    {

        $result = false;

        if(!empty($code) && !empty($contact) &&  ( $user_id !== "null" || $user_id !== null ) )
        {

            $result =  DB::table('users')->where('country_code',$code)->where('contact',$contact)->whereNotIn('id',[$user_id])->exists();

        }else if(!empty($code) && !empty($contact))
        {
              $result =  DB::table('users')->where('country_code',$code)->where('contact',$contact)->exists();

        }



/*        dump("check from helper " , $result);*/

        return $result;

    }

    function GetPackages()
    {

        $packages = Package::get();

        return $packages;
    }

    function GetCustomers()
    {
        $customers = Customer::get();

        return $customers;
    }

    function GetCars()
    {
        $cars = DB::table('cars')->get();
        return $cars;
    }

    function GetHeads()
    {
        $heads = Check_head::get();

        return $heads;

    }

    function GetHeadCheckDataByPackage($package_id)
    {

        $heads = DB::table('package_has_heads')->leftJoin('check_heads', 'package_has_heads.head_id','check_heads.head_id')->select('check_heads.head_id','check_heads.head_name')->where('package_id',$package_id)->get();



        $head_checks = [];

        foreach($heads as $list)
        {
           $temp_data =  DB::table('check_list')->select('check_id','check_name','check_option')->where('head_id',$list->head_id)->get();

           $data = null;

           $data['head_id'] =  $list->head_id;
           $data['head_name'] =  $list->head_name;

           foreach($temp_data as $list2)
           {
               $list2->check_option = explode(',' ,$list2->check_option);
               $data['check_list'][] = $list2;

           }

           $head_checks[] = $data;


        }

        return response($head_checks);


    }

    function GetBodyType()
    {
        return CarBodyType::get();

    }

    function GetInspectionStatusById($id)
    {
        return QuickCheck::where('qc_id',$id)->select('end_at')->first();

    }

    function UniqueIDGenerator($limit)
    {
        return substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, $limit);
    }


    function onUploadImage($filePath,$input,$image,$delete_path = null,$size = null)
    {
        if($delete_path !== null) {
            onRemoveImage($delete_path);
        }

            // validation for uploading image
            if (!file_exists($filePath)) {
                File::makeDirectory($filePath,0777,true);
            }

            $img = Image::make($image->getRealPath());

            if($size !== null)
            {

                $img->save($filePath.'/'.$input['temp_images'],100);

            }else
            {
                $img->resize(566, 700, function ($constraint) {
//                $constraint->aspectRatio();
                })->save($filePath.'/'.$input['temp_images']);
            }




    }

    function onRemoveImage($filePath)
    {
        // validation for deleting image so it can be upload
        if(Storage::exists($filePath)){

            Storage::delete($filePath);
        }

    }

    function onRemoveDirectory($filePath)
    {
        // validation for deleting image so it can be upload
        if(Storage::exists($filePath)){

            Storage::deleteDirectory($filePath);
        }

    }


    function WebsiteData()
    {
        return \App\Models\Setup::find(1);
    }


    function SMSSender($id)
    {


        $quick_check = QuickCheck::with('Customer')->where('qc_id',$id)->first();

        $start  = new Carbon($quick_check->sms_sent??Carbon::now()->addHour(1));
        $end    = new Carbon(date("Y-m-d H:i:s"));
        $diff_in_minutes =  $start->diffInMinutes($end);

        if(!empty($quick_check && $diff_in_minutes > 5 ))
        {

            $builder = new \AshAllenDesign\ShortURL\Classes\Builder();

            $shortURLObject = $builder->destinationUrl(route('report.get-by-id',$id))->deactivateAt(Carbon::now()->addDays(2))->make();
            $shortURL = $shortURLObject->default_short_url;



            $number = "+".(int)$quick_check['Customer']['customer_country_code'].(int)$quick_check['Customer']['customer_contact'];
            $message_body = "Dear Check First Customer, your report is now live at ".$shortURL." also now you can download a PDF file of the inspection report.";


            $sid    = env('TWILIO_SID');
            $token  = env('TWILIO_TOKEN');
            $from  = env('TWILIO_FROM');

            $twilio = new Client($sid, $token);
            $message = $twilio->messages->create($number,// to
                [
                    'from'=>$from,
                    'body'=>$message_body,
                ]
            );

            \App\Models\SmsLog::create(['number'=>$number]);

            QuickCheck::where('qc_id',$id)->update(['sms_sent'=>now()]);

            $log = [

                'qc_id'=> $id,
                'log_by'=>Auth::User()->id,
                'logs' => ' sms alert has been sent '
            ];


            CreateQCLog($log);

        }


    }

    function CreateQCLog($log)
    {
        return QuickCheckLog::create($log);
    }

    function GetCarMakes()
    {
       $temp_data = CarModelData::select('make')->groupBy('make')->get();

       $makes = [];

       foreach($temp_data as $list)
       {
          $makes[] = $list->make;
       }

       return $makes;

    }

    function GetCarModelByMake($make)
    {

        $temp_data = CarModelData::select('model','year','body_styles')->where('make',$make)->get()->toarray();

        $make_data = [];

        foreach($temp_data as $list)
        {
            $make_data[] = $list;
        }

        return $make_data;



    }

    function GetCarYearByModel($make,$model)
    {

        $temp_data = CarModelData::select('year','body_styles')->where('make',$make)->where('model',$model)->select('year')->groupBy('year')->get()->toarray();

        $make_data = [];

        foreach($temp_data as $list)
        {
            $make_data[] = $list;
        }

        return $make_data;



    }





?>
