<?php

namespace App\Http\Controllers;

use App\Models\QuickCheck;
use Illuminate\Http\Request;

class ReportsController extends Controller
{


    public function ReportAPI($id)
    {
        $report = QuickCheck::with('Car','Customer','Package')->find($id);

        $data_v1['interior'] = explode(',',$report->interior);
        $data_v1['exterior'] = explode(',',$report->exterior);
        $data_v1['mechanical_electrical'] = explode(',',$report->mechanical_electrical);
        $data_v1['test_drive'] = explode(',',$report->test_drive);
        $data_v1['additional_note'] = explode(',',$report->additional_note);

        $data_v1 = array_filter($data_v1);
        $data_v1['inspection'] = json_decode($report['inspection_data']??[]);

        $report["car"]["body_type_image"] = asset('storage/qc_data_images/'.$report->qc_id.'/body_inspector_canvas.png');

        $data = ["report_data"=>$report,
            "filter_data"=>$data_v1
        ];

        unset($report['interior'],$report['exterior'],$report['mechanical_electrical'],$report['test_drive'],$report['additional_note'],
            $report['inspection_data']
        );

        return response(['success'=>$data],200);
    }

    public function GetReport(Request $request,$id,$action = null)
    {
        $price = null;
       $report = QuickCheck::with('Car','Customer','Package')->find($id);

       $temp_package_data =json_decode($report['package']['package_data'],TRUE);

       $price = $temp_package_data[0]['Price']??null;

       $price = $report->custom_price ?? $price;

       if(empty($report))
       {
           return abort('404');
       }



       if($action !== null)
       {
           return view('report.pdf',compact('report','price'));
       }

       return view('report.index',compact('report'));


    }





}
