<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use App\Models\Setup;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class SetupController extends Controller
{
    public function Index()
    {
        $setup = Setup::get()->first();

        return view('panel.setup.index',compact('setup'));
    }



    public function Update(Request $request)
    {


        $input = $request->input();


        if(!empty($input['set_countries']))
        {
            DB::table('country_data')->where('status',1)->update(['status' => null]);
            foreach ($input['set_countries'] as $list)
            {
                DB::table('country_data')->where('FIFA',$list)->update(['status' => 1]);
            }
        }



        if(empty($input['auto_sms']))
        {
            $input['auto_sms'] = null;
        }

        if($request->hasFile('watermark'))
        {

            $image = $request->file('watermark');
            $name = "watermark.png";
            $path = "/template_assets/images/";

            $request->file('watermark')->storeAs($path, $name,'public_uploads');

        }


        if($request->hasFile('full_logo'))
        {

            $image = $request->file('full_logo');
            $name = "logo.png";
            $path = "/template_assets/images/";

            $request->file('full_logo')->storeAs($path, $name,'public_uploads');

        }

        if($request->hasFile('short_logo'))
        {

            $image = $request->file('short_logo');
            $name = "logo-56x56.png";
            $path = "/template_assets/images/";

            $request->file('short_logo')->storeAs($path, $name,'public_uploads');

        }


        $setup = Setup::find(1);
        $setup->update($input);


        return redirect()->back()->with('success','Website Setup Successfully Updated');


    }
}
