<?php

namespace App\Http\Controllers\Panel;

use App\Event\InspectionDataSent;
use App\Http\Controllers\Controller;
use App\Models\QuickCheck;
use App\Models\QuickCheckLog;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

use Twilio\Rest\Client;

class QuickCheckController extends Controller
{

    public function Index()
    {
        $pageTitle = "Quick Check";

        return view('panel.quick_check.index',compact('pageTitle'));
    }

    public function InspectionById($id)
    {
          $quick_checks = QuickCheck::leftJoin('packages','quick_checks.package_id','packages.package_id')
           ->leftJoin('cars','quick_checks.car_id','cars.car_id')
           ->leftJoin('customers','quick_checks.customer_id','customers.customer_id')
           ->select('quick_checks.*','cars.*','customers.*','packages.*')
           ->where('quick_checks.qc_id',$id)
           ->first();


          return response($quick_checks,200);

    }

    public function Created(Request $request)
    {



        $input = $request->input();

        $data['car_id'] = $input['car'];
        $data['package_id'] = $input['package'];
        $data['customer_id'] = $input['customer'];
        $data['interior'] = $input['interior'];
        $data['exterior'] = $input['exterior'];
        $data['mechanical_electrical'] = $input['mechanical_electrical'];
        $data['test_drive'] = $input['test_drive'];
        $data['additional_note'] = $input['additional_note'];

        unset($input['_token']);
        unset($input['car']);
        unset($input['package']);
        unset($input['customer']);

        $data['inspection_data'] = json_encode($input);
        $data['start_at'] = now();



         $quick_check =  QuickCheck::create($data);

        $log = [

            'qc_id'=> $quick_check['qc_id'],
            'log_by'=>Auth::User()->id,
            'logs' => ' has started the inspection'
        ];

        $this->CreateQCLog($log);

        return response($quick_check,'200');


    }


    public function Updated(Request $request,$id,$log = "")
    {
        $input = $request->input();

        $data['car_id'] = $input['car'] ?? null ;
//        $data['package_id'] = $input['package'];
        $data['customer_id'] = $input['customer'] ?? null;

        unset($input['_token'],$input['additional_note'],$input['package'],$input['exterior'],$input['interior'],$input['mechanical_electrical'],$input['test_drive']);


        if(!empty($input))
        {
            $data['inspection_data'] = json_encode($input);

            event (new InspectionDataSent(Auth::User()->id,$id,$data));
        }


        $quick_check =  QuickCheck::where('qc_id',$id)->update($data);


        $log = [

            'qc_id'=> $id,
            'log_by'=>Auth::User()->id,
            'logs' => ' has made changes in inspection '.$log

        ];

        $this->CreateQCLog($log);

        return response($quick_check,'200');

    }

    public function AdditionalNoteUpdate(Request $request,$id,$section)
    {
        $qc = QuickCheck::find($id);

        $qc->update([
            $section=>$request->data,
        ]);


        $log = [

            'qc_id'=> $id,
            'log_by'=>Auth::User()->id,
            'logs' => ' has made changes in inspection '.$section

        ];

        $this->CreateQCLog($log);


        return $request->data;
    }

    public function CreateQCLog($log)
    {
        return QuickCheckLog::create($log);
    }

    public function InProgress($id)
    {
        $pageTitle = "In Progress";


       return view('panel.quick_check.in-progress',compact('id','pageTitle'));
    }

    public function UpdateReport(Request $request,$id)
    {
        $input = $request->input();

         $update_report  = QuickCheck::find($id);

         $update_report->update([$input['key']=>$input['value']]);


         return response(['success',$input],200);

    }

    public function EndInspection($id)
    {
        QuickCheck::where('qc_id',$id)->update(['end_at'=>now()]);

        $quick_check = QuickCheck::with('Customer')->where('qc_id',$id)->first();



        $log = [

            'qc_id'=> $id,
            'log_by'=>Auth::User()->id,
            'logs' => ' has end the inspection'
        ];


        $this->CreateQCLog($log);


        if($quick_check['sms_sent'] === null && WebsiteData()['auto_sms'] !== null)
        {

            if(!empty($quick_check['Customer']['customer_country_code']) && !empty($quick_check['Customer']['customer_contact']) )
            {

                $builder = new \AshAllenDesign\ShortURL\Classes\Builder();

                $shortURLObject = $builder->destinationUrl(route('report.get-by-id',$id))->deactivateAt(Carbon::now()->addDays(2))->make();
                $shortURL = $shortURLObject->default_short_url;

                $number = "+".(int)$quick_check['Customer']['customer_country_code'].(int)$quick_check['Customer']['customer_contact'];
                $message_body = "Dear Check First Customer, your report is now live at ". $shortURL." also now you can download a PDF file of the inspection report.";

                $sid    = env('TWILIO_SID');
                $token  = env('TWILIO_TOKEN');
                $from  = env('TWILIO_FROM');

                $twilio = new Client($sid, $token);
                $message = $twilio->messages->create($number,// to
                       [
                           'from'=>$from,
                           'body'=>$message_body,
                       ]
                    );

                QuickCheck::where('qc_id',$id)->update(['sms_sent'=>now()]);

                $log = [

                    'qc_id'=> $id,
                    'log_by'=>Auth::User()->id,
                    'logs' => ' sms alert has been sent '
                ];

                $this->CreateQCLog($log);
            }



        }





        return true;

    }

    public function ContinueInspection($id)
    {
        $quick_check =QuickCheck::where('qc_id',$id)->update(['end_at'=>null]);

        $log = [

            'qc_id'=> $id,
            'log_by'=>Auth::User()->id,
            'logs' => ' has continue the inspection'
        ];

        $this->CreateQCLog($log);

        return true;

    }

    public function Manage()
    {
        $pageTitle = "Manage Inspections";

        $quick_checks = $this->GetInspections();


        return view('panel.quick_check.manage',compact('pageTitle','quick_checks'));
    }

    public function ManageAPI(){

        $quick_checks = QuickCheck::leftJoin('packages','quick_checks.package_id','packages.package_id')
            ->leftJoin('cars','quick_checks.car_id','cars.car_id')
            ->leftJoin('customers','quick_checks.customer_id','customers.customer_id')
            ->orderBy('qc_id','desc')
            ->paginate(5)->toArray();


        return response(['success'=>$quick_checks],200);

    }

    public function GetInspections()
    {

        $quick_checks = QuickCheck::leftJoin('packages','quick_checks.package_id','packages.package_id')
            ->leftJoin('cars','quick_checks.car_id','cars.car_id')
            ->leftJoin('customers','quick_checks.customer_id','customers.customer_id')
            ->orderBy('qc_id','desc')
            ->paginate(100); // Adjust the limit as needed

        return $quick_checks;




    }

    public function Destroy($id)
    {
        QuickCheck::destroy($id);

        QuickCheckLog::where('qc_id',$id)->delete();

        return redirect(route('panel.quick-check.inspection.manage'));
    }

    public function ImageUpload(Request $request)
    {

        if($request->hasFile('image')) {
            $image = $request->file('image');
            $input['temp_images'] = 'body_inspector_canvas.png';

            $destinationPath = storage_path('app/public/qc_data_images/' . $request->qc_id . '/');

            onUploadImage($destinationPath, $input, $image, null, [275, 550]);

        }
        else
        {
            return response($request,404);
        }




        return response($request,200);



    }

    public function ImageRemove(Request $request)
    {

        if(!empty($request->qc_id))
        {
            $destinationPath = '/public/qc_data_images/'.$request->qc_id.'/';

            onRemoveDirectory($destinationPath);

        }



    }

    public function Logs($id)
    {
        $data = QuickCheck::with('Car','Customer','Package','Logs.Users')->find($id);



        return view('panel.quick_check.logs',compact('data'));


    }



}
