<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use App\Models\Car;
use App\Models\Check_head;
use App\Models\Check_list;
use App\Models\Customer;
use App\Models\Package;
use App\Models\QuickCheck;
use App\Models\SmsLog;
use App\Models\User;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function Dashboard(Request $request)
    {


        $widget['customers'] = Customer::count();
        $widget['users'] = User::count();
        $widget['inspections'] = QuickCheck::count();
        $widget['pending_inspections'] = QuickCheck::where('end_at',null)->count();
        $widget['cars'] = Car::count();
        $widget['heads'] = Check_head::where('head_parent',null)->count();
        $widget['checks'] = Check_list::count();
        $widget['packages'] = Package::count();
        $widget['sms_sent'] = SmsLog::count();


        $quick_checks = $this->GetInspectionsInProcess();

        return view('panel.dashboard',compact('quick_checks','widget'));

    }

    public function GetInspectionsInProcess()
    {
        $quick_checks = QuickCheck::leftJoin('packages','quick_checks.package_id','packages.package_id')
            ->leftJoin('cars','quick_checks.car_id','cars.car_id')
            ->leftJoin('customers','quick_checks.customer_id','customers.customer_id')
            ->select('quick_checks.*','cars.*','customers.*','packages.*')
            ->where('end_at',null)
            ->get();



        return $quick_checks;

    }


}
