<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use App\Models\Car;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\Facades\Image;
use File;

class CarsController extends Controller
{
    public function Index()
    {
        $cars = Car::with('CarBodyType')->get();

        return view('panel.cars.index',compact('cars'));
    }

    public function Created(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'car_make' => 'required|string',
            'car_plate_number' => 'required|string|unique:cars,car_plate_number',
            'car_image' => 'image|mimes:jpg,png,jpeg,gif,svg|max:10120',
        ]);


        if ($validator->fails())
        {
            if(!empty($request->access_type) && $request->access_type === "api")
            {
                return response($validator->errors()->all(),200);
            }

            foreach($validator->errors()->all() as $list)
            {
                toastr()->error($list);
            }
            return redirect()->back();
        }


            $input = $request->input();

           $car = Car::create($input);

        if($request->hasFile('car_image'))
        {

            $image = $request->file('car_image');
            $input['temp_images'] = time().'.'.$image->getClientOriginalExtension();

            $destinationPath = storage_path( 'app/public/cars/'.$car['car_id'].'/image/');

            onUploadImage($destinationPath,$input,$image,null);

            DB::table('cars')->where('car_id', $car['car_id'])->update(['car_image'=>$input['temp_images']]);

        }



        if(!empty($request->access_type) && $request->access_type === "api")
        {
            return response($car,200);
        }

        toastr()->success($input['car_name']." has been added successfully");

        return redirect()->back();



    }


    public function Updated(Request $request, $id)
    {

        $validator = Validator::make($request->all(), [
            'car_make' => 'required|string',
            'car_plate_number' => 'required|string|unique:cars,car_plate_number,'.$id.',car_id',
            'car_image' => 'image|mimes:jpg,png,jpeg,gif,svg|max:10120',

        ]);

        if ($validator->fails())
        {
            foreach($validator->errors()->all() as $list)
            {
                toastr()->error($list);
            }
            return redirect()->back();
        }


        $input = $request->input();

        $car = Car::find($id);
        $car->update($input);

        if($request->hasFile('car_image'))
        {

            $image = $request->file('car_image');

            $input['temp_images'] = time().'.'.$image->getClientOriginalExtension();

            $destinationPath = storage_path( 'app/public/cars/'.$car['car_id'].'/image/');

            $delete_path = 'public/cars/'.$car['car_id']."/image/".$car['car_image'];

            onUploadImage($destinationPath,$input,$image,$delete_path);


            DB::table('cars')->where('car_id', $car['car_id'])->update(['car_image'=>$input['temp_images']]);

        }

        toastr()->success($input['car_name']." has been updated");

        return redirect()->back();


    }

    public function Destroy(Request $request, $id)
    {

        $car = Car::find($id);

        $delete_path = 'public/cars/'.$car['car_id'];

        // validation for deleting image so it can be upload
        if(Storage::exists($delete_path)){

            Storage::deleteDirectory($delete_path);
        }

        Car::destroy($id);

        toastr()->success($request->car_name.' has been deleted successfully');

        return redirect()->back();

    }

    public function GetCarByNumberPlate($car_plate_number = null , $id = null)
    {
        if($id === "null" || $id === null)
        {
            return response(Car::Where('car_plate_number',$car_plate_number)->first());

        }else
        {
            return response(Car::where('car_plate_number',$car_plate_number)->whereNotIn('car_id',[$id])->first());
        }

        return response('','404');

    }

    public function GetCarByID($id = null)
    {

            return response(Car::find($id));


    }


}
