<?php

namespace App\Http\Controllers\Panel;

use App\Http\Controllers\Controller;
use App\Models\Car;
use App\Models\CarBodyType;
use App\Models\QuickCheck;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\Facades\Image;

class BodyTypeController extends Controller
{
    public function Index()
    {
        $cby = CarBodyType::get();

        return view('panel.car_body_types.index',compact('cby'));
    }

    public function Created(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'cby_name' => 'required|string|unique:car_body_types,cby_name',
            'create_cby_image' => 'image|mimes:jpg,png,jpeg,gif,svg|max:10120',
        ]);

        if ($validator->fails())
        {
            foreach($validator->errors()->all() as $list)
            {
                toastr()->error("body type name already exists");
            }
            return redirect()->back();
        }

        $input = $request->input();

        $cby = CarBodyType::create($input);

        if($request->hasFile('create_cby_image'))
        {

            $image = $request->file('create_cby_image');
            $input['temp_images'] = "image.png";

            $destinationPath = storage_path( 'app/public/cars-body-type/'.$cby['cby_id'].'/image/');

            onUploadImage($destinationPath,$input,$image,null,'');

            DB::table('car_body_types')->where('cby_id', $cby['cby_id'])->update(['cby_image'=>$input['temp_images']]);

        }


        toastr()->success(' has been created');

        return redirect()->back();
    }

    public function updated(Request $request, $id)
    {



        $validator = Validator::make($request->all(), [
            'cby_name' => 'required|string|unique:car_body_types,cby_name,'.$id.',cby_id',
        ]);

        if ($validator->fails())
        {
            foreach($validator->errors()->all() as $list)
            {
                toastr()->error("body type name already exists");
            }
            return redirect()->back();
        }

        $input = $request->input();

        $cby  = CarBodyType::find($id);

        $cby->update($input);

        if($request->hasFile('edit_cby_image'))
        {

            $image = $request->file('edit_cby_image');

            $input['temp_images'] = "image.png";

            $destinationPath = storage_path( 'app/public/cars-body-type/'.$cby['cby_id'].'/image/');

            $delete_path = 'public/cars-body-type/'.$cby['cby_id'].'/image/'.$cby['cby_image'];

            onUploadImage($destinationPath,$input,$image,$delete_path,'');


            DB::table('car_body_types')->where('cby_id', $cby['cby_id'])->update(['cby_image'=>$input['temp_images']]);

        }

        toastr()->success($request->cby_name.' has been updated');

        return redirect()->back();
    }

    public function Destroy(Request $request , $id)
    {

        $cby =  CarBodyType::find($id);

        $delete_path = 'public/cars-body-type/'.$cby['cby_id'];

        // validation for deleting image so it can be upload
        if(Storage::exists($delete_path)){

            Storage::deleteDirectory($delete_path);
        }

        CarBodyType::destroy($id);

        toastr()->success($request->cby_name.' has been deleted successfully');

        return redirect()->back();

    }

    public function GetByName($cby_name = null, $id= null)
    {
        if($id === "null" || $id === null)
        {
            return response(CarBodyType::Where('cby_name',$cby_name)->first());

        }else
        {
            return response(CarBodyType::Where('cby_name',$cby_name)->whereNotIn('cby_id',[$id])->first());
        }

        return response('','404');
    }

    public function Canvas(Request $request , $id , $qc_id = null)
    {
        $body_type =   Car::leftJoin('car_body_types','cars.car_body_type','car_body_types.cby_id')->select('cby_id','cby_image','cby_name')->where('car_id',$id)->first();

//        $qc_image = QuickCheck::select('qc_image')->find($id)->value('qc_image');



        return view('panel.car_body_types.canvas',compact('body_type','qc_id'));
    }






}
