<?php

namespace App\Http\Controllers;

use App\Models\PackageHasHead;
use Illuminate\Http\Request;
use App\Models\Package;

class PackageController extends Controller
{
    public function Index()
    {

        $packages = Package::get();

        return view('panel.packages.index',compact('packages'));
    }

    public function Create(Request $request)
    {
        $input =  $request->input();

        try {

            request()->validate([
                'package_name' => 'required|string|unique:packages,package_name',
            ]);

        } catch (\Illuminate\Validation\ValidationException $e){

//            dump($e);

            toastr()->error($input['package_name']." package name already exists");

            return redirect(route('panel.package.index'));

        }


        if(( !empty($input['key']) &&  !empty($input['item'])) && (sizeof($input['key']) && sizeof($input['item'])) )
        {
            $temp_data = null;
            foreach($input['key'] as $key => $list)
            {

                    $temp_data[] =  [ $list => $input['item'][$key] ];
            }

            $input['package_data'] = json_encode($temp_data);

        }


        $package = Package::create($input);

        if(!empty($package['package_id']) && !empty($input['heads']))
        {
            foreach($input['heads'] as $list)
            {
                    PackageHasHead::create(['head_id'=>$list,'package_id'=>$package['package_id']]);
            }

        }


        toastr()->success($input['package_name']." package has been created");

        return redirect(route('panel.package.index'));


    }

    public function GetPackageById($id = null)
    {
        $package = Package::find($id);

        $package_heads = $this->GetHeadsByPackageId($id);

        $data['package_head'] = $package_heads;
        $data['package'] = $package;

        return response(json_encode($data), 200);
    }

    public function GetHeadsByPackageId($id)
    {
        return PackageHasHead::leftJoin('check_heads','package_has_heads.head_id','check_heads.head_id')->select('check_heads.head_id','check_heads.head_name')->where('package_id',$id)->get();
    }

    public function Updated(Request $request, $id )
    {
        $package = Package::find($id);

        $input =  $request->input();

        try {

            request()->validate([
                'package_name' => 'required|string|unique:packages,package_name,'.$id.',package_id',
            ]);

        } catch (\Illuminate\Validation\ValidationException $e)
        {

//            dump($e);

            toastr()->error($input['package_name']." package name already exists");

            return redirect(route('panel.package.index'));
        }


        if(( !empty($input['key']) &&  !empty($input['item'])) && (sizeof($input['key']) && sizeof($input['item'])) )
        {
            $temp_data = null;
            foreach($input['key'] as $key => $list)
            {

                $temp_data[] =  [ $list => $input['item'][$key] ];
            }

            $input['package_data'] = json_encode($temp_data);

        }

        $package->update($input);

        PackageHasHead::where('package_id', $id)->delete();

        if(!empty($id) && !empty($input['heads']))
        {
            foreach($input['heads'] as $list)
            {
                PackageHasHead::create(['head_id'=>$list,'package_id'=>$id]);
            }

        }

        toastr()->success($input['package_name']." package has been updated");

        return redirect(route('panel.package.index'));


    }

    public function Destroy($id)
    {
       Package::where('package_id', $id)->delete();

        toastr()->success(" package has been deleted successfully");

        return redirect(route('panel.package.index'));

    }


}
