<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Check_head;
use App\Models\Check_list;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class DataController extends Controller
{

    protected function failedValidation(Validator $validator) {
        throw new HttpResponseException(response()->json($validator->errors(), 422));
    }

    public function Index()
    {
        $heads = Check_head::select('check_heads.*','parent_head.head_name as parent_head_name','parent_head.head_id as parent_head_id')
                ->leftJoin('check_heads as parent_head','check_heads.head_parent', 'parent_head.head_id')
                ->withCount(['Check_list'])
                ->get();

        return view('panel.data.index',compact('heads'));
    }

    public function HeadCreated(Request $request)
    {


        $input = $request->input();

        try {

            request()->validate([
                'head_name' => 'required|string|unique:check_heads,head_name',
            ]);

        } catch (\Illuminate\Validation\ValidationException $e){

//            dump($e);

            toastr()->error('New Head '.$input['head_name']." already exists");

            return redirect(route('panel.data.index'));

        }


        Check_head::create($input);

        toastr()->success('New Head '.$input['head_name']." has been created");

        return redirect(route('panel.data.index'));


    }


    function CheckCreated(Request $request)
    {

        if(sizeof($request->check_name) === sizeof($request->check_option))
        {

            $input = $request->input();

            foreach($input['check_name'] as $key => $list )
            {

                 Check_list::create(['head_id'=>$input['head_id'],'check_name' => $list , 'check_option' => $input['check_option'][$key]]);

            }

            toastr()->success("New Check list has been created successfully");

            return redirect(route('panel.data.index'));

        }
        else
        {
            toastr()->error("Something went wrong...");

            return redirect(route('panel.data.index'));

        }


    }

    public function HeadUpdated(Request $request , $head_id = null)
    {



        if($head_id !== null && $head_id !== $request->head_parent)
        {

            $input = $request->input();

            try {

                request()->validate([
                    'head_name' => 'required|string|unique:check_heads,head_name,'.$head_id.',head_id',
                ]);

            } catch (\Illuminate\Validation\ValidationException $e){

//            dump($e);

                toastr()->error('Head '.$input['head_name']." already exists");

                return redirect(route('panel.data.index'));

            }

            $check_head = Check_head::find($head_id);
            $check_head->update($input);

            toastr()->success('New Head '.$input['head_name']." has been created");


            return redirect(route('panel.data.index'));

        }


            toastr()->error("Something went wrong...");

            return redirect(route('panel.data.index'));



    }

    public function EditCheckListByHead($head_id = null){

       $check_list =  Check_list::leftJoin('check_heads','check_list.head_id','check_heads.head_id')->select('check_list.*','check_heads.head_name')->where('check_list.head_id',$head_id)->get();

        return response($check_list);


    }

    public function CheckUpdated(Request $request, $head_id = null)
    {

        if(!empty($request->remove_id))
        {
            foreach($request->remove_id as $list)
            {
                Check_list::where('check_id',$list)->delete();
            }
        }




        if((!empty($request->check_name) && !empty($request->check_option)) && sizeof($request->check_name) === sizeof($request->check_option))
        {
           if($request->head_id !== $head_id)
           {
               $head_id = $request->head_id;
           }

            $input = $request->input();



            foreach($input['check_name'] as $key => $list )
            {
                if($input['check_id'][$key]!=="new")
                {
                    $temp_data = array('head_id'=>$head_id,'check_name' => $list , 'check_option' => $input['check_option'][$key]);

                    $check_list = Check_list::find($input['check_id'][$key]);
                    $check_list->update($temp_data);

                }
                elseif($input['check_id'][$key] ==="new")
                {
                    $temp_data = array('head_id'=>$head_id,'check_name' => $list , 'check_option' => $input['check_option'][$key]);

                    $check_list = Check_list::create($temp_data);


                }



            }

            toastr()->success("Your check list has been updated successfully");

            return redirect(route('panel.data.index'));

        }
        else
        {

            Check_list::where('head_id',$head_id)->delete();
            toastr()->error("Check list has been truncated successfully..");

            return redirect(route('panel.data.index'));

        }
    }

    public function ReturnError()
    {
        toastr()->error("Something went wrong...");

        return redirect(route('panel.data.index'));
    }

    public function ReturnJsonError()
    {
        toastr()->error("Something went wrong...");

        return response(false);
    }

    public function DestroyHead(Request $request,$head_id)
    {
        Check_head::where('head_id',$head_id)->delete();

        Check_list::where('head_id',$head_id)->update(['head_id'=>null]);

        toastr()->success($request->head_name." has been deleted successfully");

        return redirect(route('panel.data.index'));

    }



}
