<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\Facades\Image;

class CustomerController extends Controller
{
    public function Index()
    {
        $customers = Customer::get();


        return view('panel.customers.index',compact('customers'));

    }

    public function Created(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'customer_name' => 'required|string',
            'customer_email' => 'nullable|unique:customers,customer_email',
            'customer_image' => 'image|mimes:jpg,png,jpeg,gif,svg|max:10100',

        ]);

        if(!empty($request->customer_contact))
        {

            $customer_data_via_contact = $this->GetCustomerByContact($request->customer_country_code,$request->customer_contact,null);

            foreach ($customer_data_via_contact as $list)
            {
                if(!empty($list->customer_contact))
                {
                    if(!empty($request->access_type) && $request->access_type === "api")
                    {
                        return response("Contact Number Already Exists",200);
                    }
                    toastr()->error("Contact Number Already Exists");
                    return redirect()->back();

                }
            }

        }

        if ($validator->fails())
        {
            if(!empty($request->access_type) && $request->access_type === "api")
            {
                return response($validator->errors()->all(),200);
            }

            foreach($validator->errors()->all() as $list)
            {
                toastr()->error($list);
            }

            return redirect()->back();
        }





        $input = $request->input();

        $customer = Customer::create($input);

        if($request->hasFile('customer_image'))
        {

            $image = $request->file('customer_image');
            $input['temp_images'] = time().'.'.$image->getClientOriginalExtension();

            $destinationPath = storage_path( 'app/public/customers/'.$customer['customer_id'].'/');

            onUploadImage($destinationPath,$input,$image,null);

            DB::table('customers')->where('customer_id', $customer['customer_id'])->update(['customer_image'=>$input['temp_images']]);

        }

        if(!empty($request->access_type) && $request->access_type === "api")
        {
            return response($customer,200);
        }
        toastr()->success('New Customer has been created');

        return redirect()->back();
    }

    public function Updated(Request $request, $id)
    {



        $input = $request->input();

//        'email' => 'required|email|unique:users,email,'.$id,

        $validator = Validator::make($request->all(), [
            'customer_name' => 'required|string',
            'customer_email' => 'nullable|unique:customers,customer_email,'.$id.',customer_id',
            'customer_image' => 'image|mimes:jpg,png,jpeg,gif,svg|max:10100',

        ]);

        $customer_data_via_contact = $this->GetCustomerByContact($request->customer_country_code,$request->customer_contact,$id);


        foreach ($customer_data_via_contact as $list)
        {
            if(!empty($list->customer_contact))
            {
                unset($input['customer_contact']);

                unset($input['customer_country_code']);

                toastr()->error("Contact Number Already Exists");
//                return redirect()->back();

            }
        }

        if ($validator->fails())
        {
            foreach($validator->errors()->all() as $list)
            {
                toastr()->error($list);
            }

            unset($input['customer_email']);
//            return redirect()->back();
        }



        $customer = Customer::find($id);

        $customer->update($input);


        if($request->hasFile('customer_image'))
        {


            $image = $request->file('customer_image');

            $input['temp_images'] = time().'.'.$image->getClientOriginalExtension();

            $destinationPath = storage_path( 'app/public/customers/'.$customer['customer_id'].'/');



            $delete_path = 'public/customers/'.$customer['customer_id']."/".$customer['customer_image'];

            onUploadImage($destinationPath,$input,$image,$delete_path);

            DB::table('customers')->where('customer_id', $customer['customer_id'])->update(['customer_image'=>$input['temp_images']]);

        }

        toastr()->success($request->customer_name.' Customer has been updated');

        return redirect()->back();

    }

    public function Destroy(Request $request, $id)
    {
        $customer = Customer::find($id);


        $delete_path = 'public/customers/'.$customer['customer_id'];


        // validation for deleting image so it can be upload
        if(Storage::exists($delete_path)){

            Storage::deleteDirectory($delete_path);
        }

        Customer::destroy($id);

        toastr()->success($request->customer_name.' customer has been deleted successfully');

        return redirect()->back();

    }

    public function GetCustomerByEmail($email = null,$id = null)
    {
        if($id === "null" || $id === null)
        {
            return response(Customer::where(['customer_email' => $email])->first());

        }else
        {
            return response(Customer::where(['customer_email' => $email])->whereNotIn('customer_id',[$id])->first());
        }


    }

    public function GetCustomerByContact($country_code = null, $contact = null ,$id = null)
    {

        if($id === "null" || $id === null)
        {
            return response(Customer::where('customer_contact', $contact)->where('customer_country_code',$country_code)->first());

        }else
        {

            return response(Customer::where('customer_contact',$contact)->where('customer_country_code',$country_code)->whereNotIn('customer_id',[$id])->first());
        }



    }



}
